/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.mode;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.api.IFieldInteraction;
import mffs.api.IProjector;
import mffs.item.mode.ItemMode;
import mffs.render.model.ModelCube;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import universalelectricity.core.vector.Vector3;

public class ItemModeSphere
extends ItemMode {
    public ItemModeSphere(int i) {
        super(i, "modeSphere");
    }

    @Override
    public Set getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        int radius = projector.getModuleCount(ModularForceFieldSystem.itemModuleScale, new int[0]);
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)radius / 2.0));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                Vector3 point = new Vector3(Math.sin(theta) * Math.cos(phi), Math.cos(theta), Math.sin(theta) * Math.sin(phi)).multiply(radius);
                fieldBlocks.add(point);
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        Vector3 translation = projector.getTranslation();
        int radius = projector.getModuleCount(ModularForceFieldSystem.itemModuleScale, new int[0]);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    Vector3 position = new Vector3(x, y, z);
                    if (!this.isInField(projector, Vector3.add(position, new Vector3((TileEntity)projector)).add(translation))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3 position) {
        return new Vector3((TileEntity)projector).add(projector.getTranslation()).distanceTo(position) < (double)projector.getModuleCount(ModularForceFieldSystem.itemModuleScale, new int[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IProjector projector, double x1, double y1, double z1, float f, long ticks) {
        float scale = 0.15f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float radius = 1.5f;
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)radius / 2.0));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                Vector3 vector = new Vector3(Math.sin(theta) * Math.cos(phi), Math.cos(theta), Math.sin(theta) * Math.sin(phi));
                vector.multiply(radius);
                GL11.glTranslated((double)vector.x, (double)vector.y, (double)vector.z);
                ModelCube.INSTNACE.render();
                GL11.glTranslated((double)(-vector.x), (double)(-vector.y), (double)(-vector.z));
            }
        }
    }
}

