/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.mode;

import calclavia.lib.CalculationHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import mffs.api.IFieldInteraction;
import mffs.api.IProjector;
import mffs.item.mode.ItemMode;
import mffs.render.model.ModelCube;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.vector.Region3;

public class ItemModeCube
extends ItemMode {
    public ItemModeCube(int i, String name) {
        super(i, name);
    }

    public ItemModeCube(int i) {
        this(i, "modeCube");
    }

    @Override
    public Set getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        Vector3 posScale = projector.getPositiveScale();
        Vector3 negScale = projector.getNegativeScale();
        for (float x = (float)(-negScale.intX()); x <= (float)posScale.intX(); x += 0.5f) {
            for (float z = (float)(-negScale.intZ()); z <= (float)posScale.intZ(); z += 0.5f) {
                for (float y = (float)(-negScale.intY()); y <= (float)posScale.intY(); y += 0.5f) {
                    if (y != (float)(-negScale.intY()) && y != (float)posScale.intY() && x != (float)(-negScale.intX()) && x != (float)posScale.intX() && z != (float)(-negScale.intZ()) && z != (float)posScale.intZ()) continue;
                    fieldBlocks.add(new Vector3(x, y, z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        Vector3 posScale = projector.getPositiveScale();
        Vector3 negScale = projector.getNegativeScale();
        for (int x = -negScale.intX(); x <= posScale.intX(); ++x) {
            for (int z = -negScale.intZ(); z <= posScale.intZ(); ++z) {
                for (int y = -negScale.intY(); y <= posScale.intY(); ++y) {
                    fieldBlocks.add(new Vector3(x, y, z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3 position) {
        Vector3 projectorPos = new Vector3((TileEntity)projector);
        projectorPos.add(projector.getTranslation());
        Vector3 relativePosition = position.clone().subtract(projectorPos);
        CalculationHelper.rotateByAngle(relativePosition, -projector.getRotationYaw(), -projector.getRotationPitch());
        Region3 region = new Region3(projector.getNegativeScale().clone().multiply(-1.0), projector.getPositiveScale());
        return region.isIn(relativePosition);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        ModelCube.INSTNACE.render();
    }
}

