/*
 * Decompiled with CFR 0.152.
 */
package mffs.event;

import mffs.DelayedEvent;
import mffs.IDelayedEventHandler;
import mffs.ManipulatorHelper;
import mffs.api.ISpecialForceManipulation;
import mffs.event.BlockPostMoveDelayedEvent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;

public class BlockPreMoveDelayedEvent
extends DelayedEvent {
    private World world;
    private Vector3 position;
    private Vector3 newPosition;

    public BlockPreMoveDelayedEvent(IDelayedEventHandler handler, int ticks, World world, Vector3 position, Vector3 newPosition) {
        super(handler, ticks);
        this.world = world;
        this.position = position;
        this.newPosition = newPosition;
    }

    @Override
    protected void onEvent() {
        if (!this.world.field_72995_K) {
            TileEntity tileEntity = this.position.getTileEntity((IBlockAccess)this.world);
            if (tileEntity instanceof ISpecialForceManipulation) {
                ((ISpecialForceManipulation)tileEntity).move(this.newPosition.intX(), this.newPosition.intY(), this.newPosition.intZ());
            }
            int blockID = this.position.getBlockID((IBlockAccess)this.world);
            int blockMetadata = this.position.getBlockMetadata((IBlockAccess)this.world);
            NBTTagCompound tileData = new NBTTagCompound();
            if (tileEntity != null) {
                tileEntity.func_70310_b(tileData);
            }
            ManipulatorHelper.setBlockSneaky(this.world, this.position, 0, 0, null);
            this.handler.getQuedDelayedEvents().add(new BlockPostMoveDelayedEvent(this.handler, 0, this.world, this.position, this.newPosition, blockID, blockMetadata, tileEntity, tileData));
        }
    }
}

