/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import calclavia.lib.IUniversalEnergyTile;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import java.util.EnumSet;
import mffs.base.TileEntityModuleAcceptor;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public abstract class TileEntityUniversalEnergy
extends TileEntityModuleAcceptor
implements IEnergySource,
IUniversalEnergyTile {
    public double prevWatts;
    public double wattsReceived = 0.0;
    private IPowerProvider powerProvider;

    public TileEntityUniversalEnergy() {
        if (PowerFramework.currentFramework != null && this.powerProvider == null) {
            this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
            this.powerProvider.configure(0, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        }
    }

    @Override
    public void initiate() {
        super.initiate();
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
    }

    @Override
    public void func_70313_j() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        super.func_70313_j();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.prevWatts = this.wattsReceived;
        if (!this.field_70331_k.field_72995_K) {
            if (!this.isDisabled()) {
                ElectricityPack electricityPack = ElectricityNetworkHelper.consumeFromMultipleSides(this, this.getConsumingSides(), this.getRequest());
                this.onReceive(electricityPack);
            } else {
                ElectricityNetworkHelper.consumeFromMultipleSides(this, new ElectricityPack());
            }
        }
        if (this.powerProvider != null) {
            this.powerProvider.configure(0, 0, Integer.MAX_VALUE, 0, (int)Math.ceil(this.getWattBuffer() * UniversalElectricity.TO_BC_RATIO));
            float requiredEnergy = (float)(this.getRequest().getWatts() * UniversalElectricity.TO_BC_RATIO);
            float energyReceived = this.powerProvider.useEnergy(0.0f, requiredEnergy, true);
            this.onReceive(ElectricityPack.getFromWatts(UniversalElectricity.BC3_RATIO * (double)energyReceived, this.getVoltage()));
        }
    }

    public ElectricityPack produce(double watts) {
        ElectricityPack pack = new ElectricityPack(watts / this.getVoltage(), this.getVoltage());
        ElectricityPack remaining = ElectricityNetworkHelper.produceFromMultipleSides(this, pack);
        if (remaining.getWatts() > 0.0) {
            EnumSet approachingDirections = ElectricityNetworkHelper.getDirections(this);
            for (ForgeDirection direction : approachingDirections) {
                TileEntity tileEntity = VectorHelper.getTileEntityFromSide(this.field_70331_k, new Vector3(this), direction);
                if (this.getPowerProvider(tileEntity) == null) continue;
                this.getPowerProvider(tileEntity).receiveEnergy((float)(remaining.getWatts() * UniversalElectricity.TO_BC_RATIO), direction.getOpposite());
            }
        }
        if (remaining.getWatts() > 0.0) {
            EnergyTileSourceEvent evt = new EnergyTileSourceEvent(this, (int)(remaining.getWatts() * UniversalElectricity.TO_IC2_RATIO));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            remaining = new ElectricityPack((double)evt.amount * UniversalElectricity.IC2_RATIO / remaining.voltage, remaining.voltage);
        }
        return remaining;
    }

    protected EnumSet getConsumingSides() {
        return ElectricityNetworkHelper.getDirections(this);
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack();
    }

    public void onReceive(ElectricityPack electricityPack) {
        if (UniversalElectricity.isVoltageSensitive && electricityPack.voltage > this.getVoltage()) {
            return;
        }
        this.wattsReceived = Math.min(this.wattsReceived + electricityPack.getWatts(), this.getWattBuffer());
    }

    public double getWattBuffer() {
        return this.getRequest().getWatts() * 2.0;
    }

    @Override
    public double getVoltage() {
        return 120.0;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        if (this.getConsumingSides() != null) {
            return this.getConsumingSides().contains(direction.toForgeDirection());
        }
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.ticks > 0L;
    }

    @Override
    public int demandsEnergy() {
        return (int)Math.ceil(this.getRequest().getWatts() * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenElectricity = (double)i * UniversalElectricity.IC2_RATIO;
        double rejects = 0.0;
        if (givenElectricity > this.getWattBuffer()) {
            rejects = givenElectricity - this.getRequest().getWatts();
        }
        this.onReceive(new ElectricityPack(givenElectricity / this.getVoltage(), this.getVoltage()));
        return (int)(rejects * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return this.canConnect(direction.toForgeDirection());
    }

    @Override
    public int getMaxEnergyOutput() {
        return 2048;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.canConnect(from)) {
            return (int)Math.ceil(this.getRequest().getWatts() * UniversalElectricity.TO_BC_RATIO);
        }
        return 0;
    }

    public IPowerProvider getPowerProvider(TileEntity tileEntity) {
        if (tileEntity instanceof IPowerReceptor) {
            return ((IPowerReceptor)tileEntity).getPowerProvider();
        }
        return null;
    }
}

