/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import com.google.common.io.ByteArrayDataInput;
import icbm.api.IBlockFrequency;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import mffs.api.IBiometricIdentifierLink;
import mffs.api.card.ICardLink;
import mffs.api.security.IBiometricIdentifier;
import mffs.base.TileEntityBase;
import mffs.base.TileEntityInventory;
import mffs.fortron.FrequencyGrid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import universalelectricity.core.vector.Vector3;

public abstract class TileEntityFrequency
extends TileEntityInventory
implements IBlockFrequency,
IBiometricIdentifierLink {
    private int frequency;

    @Override
    public void initiate() {
        FrequencyGrid.instance().register(this);
        super.initiate();
    }

    public void func_70313_j() {
        FrequencyGrid.instance().unregister(this);
        super.func_70313_j();
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityBase.TilePacketType.FREQUENCY.ordinal()) {
            this.setFrequency(dataStream.readInt());
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.setFrequency(nbt.func_74762_e("frequency"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("frequency", this.getFrequency());
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    @Override
    public IBiometricIdentifier getBiometricIdentifier() {
        if (this.getBiometricIdentifiers().size() > 0) {
            return (IBiometricIdentifier)this.getBiometricIdentifiers().toArray()[0];
        }
        return null;
    }

    @Override
    public Set getBiometricIdentifiers() {
        HashSet<IBiometricIdentifier> list = new HashSet<IBiometricIdentifier>();
        for (ItemStack itemStack : this.getCards()) {
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ICardLink)) continue;
            Vector3 linkedPosition = ((ICardLink)itemStack.func_77973_b()).getLink(itemStack);
            TileEntity tileEntity = linkedPosition.getTileEntity((IBlockAccess)this.field_70331_k);
            if (linkedPosition == null || !(tileEntity instanceof IBiometricIdentifier)) continue;
            list.add((IBiometricIdentifier)tileEntity);
        }
        for (IBlockFrequency tileEntity : FrequencyGrid.instance().get(this.getFrequency())) {
            if (!(tileEntity instanceof IBiometricIdentifier)) continue;
            list.add((IBiometricIdentifier)((Object)tileEntity));
        }
        return list;
    }
}

