/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import mffs.MFFSHelper;
import mffs.Settings;
import mffs.TransferMode;
import mffs.api.ISpecialForceManipulation;
import mffs.api.card.ICard;
import mffs.api.fortron.IFortronFrequency;
import mffs.base.TileEntityFrequency;
import mffs.fortron.FortronHelper;
import mffs.fortron.FrequencyGrid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.PacketManager;

public abstract class TileEntityFortron
extends TileEntityFrequency
implements ITankContainer,
IFortronFrequency,
ISpecialForceManipulation {
    protected LiquidTank fortronTank = new LiquidTank(FortronHelper.LIQUID_FORTRON.copy(), 1000, (TileEntity)this);
    private boolean markSendFortron = true;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!Settings.CONSERVE_PACKETS && this.ticks % 60L == 0L) {
            PacketManager.sendPacketToClients(this.func_70319_e(), this.field_70331_k, new Vector3(this), 30.0);
        }
    }

    @Override
    public void func_70313_j() {
        if (this.markSendFortron) {
            MFFSHelper.transferFortron(this, FrequencyGrid.instance().getFortronTiles(this.field_70331_k, new Vector3(this), 100, this.getFrequency()), TransferMode.DRAIN, Integer.MAX_VALUE);
        }
        super.func_70313_j();
    }

    @Override
    public boolean preMove(int x, int y, int z) {
        return true;
    }

    @Override
    public void move(int x, int y, int z) {
        this.markSendFortron = false;
    }

    @Override
    public void postMove() {
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.fortronTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fortron")));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.fortronTank.getLiquid() != null) {
            NBTTagCompound fortronCompound = new NBTTagCompound();
            this.fortronTank.getLiquid().writeToNBT(fortronCompound);
            nbt.func_74782_a("fortron", (NBTBase)fortronCompound);
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource.isLiquidEqual(FortronHelper.LIQUID_FORTRON)) {
            return this.fortronTank.fill(resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.getOrientation((int)tankIndex), resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.fortronTank.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.drain(ForgeDirection.getOrientation((int)tankIndex), maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.fortronTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (type.isLiquidEqual(FortronHelper.LIQUID_FORTRON)) {
            return this.fortronTank;
        }
        return null;
    }

    @Override
    public void setFortronEnergy(int joules) {
        this.fortronTank.setLiquid(FortronHelper.getFortron(joules));
    }

    @Override
    public int getFortronEnergy() {
        return FortronHelper.getAmount(this.fortronTank);
    }

    @Override
    public int getFortronCapacity() {
        return this.fortronTank.getCapacity();
    }

    @Override
    public int requestFortron(int joules, boolean doUse) {
        return FortronHelper.getAmount(this.fortronTank.drain(joules, doUse));
    }

    @Override
    public int provideFortron(int joules, boolean doUse) {
        return this.fortronTank.fill(FortronHelper.getFortron(joules), doUse);
    }

    public ItemStack getCard() {
        ItemStack itemStack = this.func_70301_a(0);
        if (itemStack != null && itemStack.func_77973_b() instanceof ICard) {
            return itemStack;
        }
        return null;
    }
}

