/*
 * Decompiled with CFR 0.152.
 */
package calclavia.lib;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;

public class CalculationHelper {
    public static void rotateByAngle(Vector3 vector, double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double x = vector.x;
        double z = vector.z;
        if (yaw != 0.0) {
            vector.x = x * Math.cos(yawRadians) - z * Math.sin(yawRadians);
            vector.z = x * Math.sin(yawRadians) + z * Math.cos(yawRadians);
        }
    }

    public static void rotateByAngle(Vector3 vector, double yaw, double pitch) {
        CalculationHelper.rotateByAngle(vector, yaw, pitch, 0.0);
    }

    public static void rotateByAngle(Vector3 vector, double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double x = vector.x;
        double y = vector.y;
        double z = vector.z;
        vector.x = x * Math.cos(yawRadians) * Math.cos(pitchRadians) + z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        vector.z = x * Math.sin(yawRadians) * Math.cos(pitchRadians) + z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        vector.y = -x * Math.sin(pitchRadians) + z * Math.cos(pitchRadians) * Math.sin(rollRadians) + y * Math.cos(pitchRadians) * Math.cos(rollRadians);
    }

    public static Vector3 getDeltaPositionFromRotation(float rotationYaw, float rotationPitch) {
        rotationPitch = -rotationPitch;
        return new Vector3(Math.cos(Math.toRadians(rotationYaw += 90.0f)), Math.sin(Math.toRadians(rotationPitch)), Math.sin(Math.toRadians(rotationYaw)));
    }

    public static MovingObjectPosition raytraceEntities(World world, Vector3 startPosition, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        MovingObjectPosition pickedEntity = null;
        Vec3 startingPosition = startPosition.toVec3();
        Vec3 look = CalculationHelper.getDeltaPositionFromRotation(rotationYaw, rotationPitch).toVec3();
        Vec3 reachPoint = Vec3.func_72443_a((double)(startingPosition.field_72450_a + look.field_72450_a * reachDistance), (double)(startingPosition.field_72448_b + look.field_72448_b * reachDistance), (double)(startingPosition.field_72449_c + look.field_72449_c * reachDistance));
        double playerBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = AxisAlignedBB.func_72332_a().func_72299_a(-playerBorder, -playerBorder, -playerBorder, playerBorder, playerBorder, playerBorder);
        List entitiesHit = world.func_72839_b(null, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.field_70121_D == null || (hitMOP = (aabb = entityHit.field_70121_D.func_72314_b((double)(border = entityHit.func_70111_Y()), (double)border, (double)border)).func_72327_a(startingPosition, reachPoint)) == null) continue;
            if (aabb.func_72318_a(startingPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new MovingObjectPosition(entityHit)) == null) continue;
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = startingPosition.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(entityHit);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public static MovingObjectPosition raytraceBlocks(World world, Vector3 startPosition, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        Vector3 lookVector = CalculationHelper.getDeltaPositionFromRotation(rotationYaw, rotationPitch);
        Vector3 reachPoint = Vector3.add(startPosition, Vector3.multiply(lookVector, reachDistance));
        return world.func_72831_a(startPosition.toVec3(), reachPoint.toVec3(), collisionFlag, !collisionFlag);
    }

    public static MovingObjectPosition doCustomRayTrace(World world, Vector3 startPosition, float rotationYaw, float rotationPitch, boolean collisionFlag, double reachDistance) {
        MovingObjectPosition pickedBlock = CalculationHelper.raytraceBlocks(world, startPosition, rotationYaw, rotationPitch, collisionFlag, reachDistance);
        MovingObjectPosition pickedEntity = CalculationHelper.raytraceEntities(world, startPosition, rotationYaw, rotationPitch, collisionFlag, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        double dBlock = startPosition.distanceTo(new Vector3(pickedBlock.field_72307_f));
        double dEntity = startPosition.distanceTo(new Vector3(pickedEntity.field_72307_f));
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }
}

