/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.core.genetics.BinnieGenetics;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceManager;
import binnie.core.resource.ResourceType;
import binnie.extratrees.ExtraTrees;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterflyRoot;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public enum ButterflySpecies implements IAlleleButterflySpecies
{
    WhiteAdmiral("White Admiral", "Limenitis camilla"),
    PurpleEmperor("Purple Emperor", "Apatura iris"),
    RedAdmiral("Red Admiral", "Vanessa atalanta"),
    PaintedLady("Painted Lady", "Vanessa cardui"),
    SmallTortoiseshell("Small Tortoiseshell", "Aglais urticae"),
    CamberwellBeauty("Camberwell Beauty", "Aglais antiopa"),
    Peacock("Peacock", "Inachis io"),
    Wall("Wall", "Lasiommata megera"),
    CrimsonRose("Crimson Rose", "Atrophaneura hector"),
    KaiserIHind("Kaiser-i-Hind", "Teinopalpus imperialis"),
    GoldenBirdwing("Golden Birdwing", "Troides aeacus"),
    MarshFritillary("Marsh Fritillary", "Euphydryas aurinia"),
    PearlBorderedFritillary("Pearl-bordered Fritillary", "Boloria euphrosyne"),
    QueenOfSpainFritillary("Queen of Spain Fritillary", "Issoria lathonia"),
    SpeckledWood("Speckled Wood", "Pararge aegeria"),
    ScotchAngus("Scotch Angus", "Erebia aethiops"),
    Gatekeeper("Gatekeeper", "Pyronia tithonus");

    String name;
    String branchName;
    String scientific;
    BinnieResource texture;
    public IClassification branch;
    private Map butterflyLoot = new HashMap();
    private Map caterpillarLoot = new HashMap();

    /*
     * WARNING - void declaration
     */
    private ButterflySpecies() {
        void scientific;
        void name;
        this.name = name;
        this.branchName = scientific.split(" ")[0].toLowerCase();
        this.scientific = scientific.split(" ")[1];
        this.texture = ResourceManager.getPNG(ExtraTrees.instance, ResourceType.Entity, this.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "";
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    public boolean hasEffect() {
        return false;
    }

    public boolean isSecret() {
        return false;
    }

    public boolean isCounted() {
        return true;
    }

    public String getBinomial() {
        return this.scientific;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return null;
    }

    public String getUID() {
        return "extrabutterflies.species." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return true;
    }

    public String getEntityTexture() {
        return this.texture.getFullPath();
    }

    public IAllele[] getTemplate() {
        IAllele[] def = (IAllele[])this.getRoot().getDefaultTemplate().clone();
        def[0] = this;
        return def;
    }

    public IButterflyRoot getRoot() {
        return BinnieGenetics.getButterflyRoot();
    }

    public float getRarity() {
        return 0.5f;
    }

    public boolean isNocturnal() {
        return false;
    }

    public int getIconColour(int renderPass) {
        return 0xFFFFFF;
    }

    public Map getButterflyLoot() {
        return new HashMap();
    }

    public Map getCaterpillarLoot() {
        return new HashMap();
    }

    public int getComplexity() {
        return 4;
    }

    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (itemstack.field_77993_c == Item.field_77729_bt.field_77779_bT) {
            return 0.9f;
        }
        for (ItemStack itemStack : this.butterflyLoot.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack itemStack : this.caterpillarLoot.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeyDrop").field_77993_c) {
            return 0.5f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeydew").field_77993_c) {
            return 0.7f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"beeComb").field_77993_c) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, String researcher, IIndividual individual, int bountyLevel) {
        return new ItemStack[]{this.getRoot().getMemberStack(individual.copy(), EnumFlutterType.SERUM.ordinal())};
    }

    public EnumSet getSpawnBiomes() {
        return EnumSet.noneOf(BiomeDictionary.Type.class);
    }

    public boolean strictSpawnMatch() {
        return false;
    }

    public float getFlightDistance() {
        return 5.0f;
    }
}

