/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.BinnieCore;
import binnie.core.block.ItemMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.core.plugin.IBinnieModule;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.PluginExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.ICarpentryWood;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.carpentry.BlockCarpentry;
import binnie.extratrees.carpentry.BlockCarpentryPanel;
import binnie.extratrees.carpentry.CarpentryBlock;
import binnie.extratrees.carpentry.CarpentryBlockRenderer;
import binnie.extratrees.carpentry.CarpentryInterface;
import binnie.extratrees.carpentry.CarpentryItemRenderer;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.config.ConfigurationMain;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class ModuleCarpentry
implements IBinnieModule {
    @Override
    public void preInit() {
        ExtraTrees.blockCarpentry = new BlockCarpentry(ConfigurationMain.tileID);
        ExtraTrees.blockPanel = new BlockCarpentryPanel(ConfigurationMain.panelID);
        GameRegistry.registerBlock((Block)ExtraTrees.blockCarpentry, ItemMetadata.class, (String)"extratrees.block.carpentry");
        GameRegistry.registerBlock((Block)ExtraTrees.blockPanel, ItemMetadata.class, (String)"extratrees.block.panel");
        BinnieCore.proxy.registerCustomItemRenderer(Item.field_77698_e[ExtraTrees.blockCarpentry.field_71990_ca].field_77779_bT, new CarpentryItemRenderer());
        MinecraftForge.EVENT_BUS.register((Object)ExtraTrees.blockCarpentry);
        BinnieCore.proxy.registerCustomItemRenderer(Item.field_77698_e[ExtraTrees.blockPanel.field_71990_ca].field_77779_bT, new CarpentryItemRenderer());
    }

    @Override
    public void doInit() {
        PluginExtraTrees.carpentryID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new CarpentryBlockRenderer());
    }

    @Override
    public void postInit() {
        for (EnumDesign design : EnumDesign.values()) {
            CarpentryManager.carpentryInterface.registerDesign(design.ordinal(), design);
        }
    }

    public static ItemStack getItemStack(BlockCarpentry block, ICarpentryWood type1, ICarpentryWood type2, IDesign design) {
        return ModuleCarpentry.getItemStack(block, CarpentryManager.carpentryInterface.getCarpentryWoodIndex(type1), CarpentryManager.carpentryInterface.getCarpentryWoodIndex(type2), CarpentryManager.carpentryInterface.getDesignIndex(design));
    }

    public static ItemStack getItemStack(BlockCarpentry block, int type1, int type2, int design) {
        return TileEntityMetadata.getItemStack(block.field_71990_ca, ModuleCarpentry.getMetadata(type1, type2, design, 0, ForgeDirection.UP.ordinal()));
    }

    public static ItemStack getItemStack(BlockCarpentry blockC, CarpentryBlock block) {
        return ModuleCarpentry.getItemStack(blockC, block.getPrimaryWood(), block.getSecondaryWood(), block.getDesign());
    }

    public static int getMetadata(int plank1, int plank2, int design, int rotation, int facing) {
        return plank1 + (plank2 << 8) + (design << 16) + (rotation << 26) + (facing << 28);
    }

    public static CarpentryBlock getCarpentryBlock(int meta) {
        int damage = meta;
        int plankID1 = damage & 0xFF;
        int plankID2 = damage >> 8 & 0xFF;
        int tile = damage >> 16 & 0x3FF;
        int rotation = damage >> 26 & 3;
        int axis = damage >> 28 & 7;
        ICarpentryWood type1 = CarpentryManager.carpentryInterface.getCarpentryWood(plankID1);
        ICarpentryWood type2 = CarpentryManager.carpentryInterface.getCarpentryWood(plankID2);
        IDesign type = CarpentryManager.carpentryInterface.getDesign(tile);
        return new CarpentryBlock(type1, type2, type, rotation, ForgeDirection.getOrientation((int)axis));
    }

    public static CarpentryBlock getCarpentryPanel(int meta) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(meta);
        block.setPanel();
        return block;
    }

    public static int getBlockMetadata(CarpentryBlock block) {
        int plank1 = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(block.getPrimaryWood());
        int plank2 = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(block.getSecondaryWood());
        int design = CarpentryManager.carpentryInterface.getDesignIndex(block.getDesign());
        int rotation = block.getRotation();
        int facing = block.getFacing().ordinal();
        return ModuleCarpentry.getMetadata(plank1, plank2, design, rotation, facing);
    }

    public static int getItemMetadata(CarpentryBlock block) {
        int plank1 = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(block.getPrimaryWood());
        int plank2 = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(block.getSecondaryWood());
        int design = CarpentryManager.carpentryInterface.getDesignIndex(block.getDesign());
        return ModuleCarpentry.getMetadata(plank1, plank2, design, 0, ForgeDirection.UP.ordinal());
    }

    static {
        CarpentryManager.carpentryInterface = new CarpentryInterface();
    }

    static enum Axis {
        Y,
        X,
        Z;

    }
}

