/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.extratrees.api.ICarpentryInterface;
import binnie.extratrees.api.ICarpentryWood;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignCategory;
import binnie.extratrees.api.ILayout;
import binnie.extratrees.api.IPattern;
import binnie.extratrees.carpentry.Layout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CarpentryInterface
implements ICarpentryInterface {
    static Map woodMap = new LinkedHashMap();
    static Map designMap = new LinkedHashMap();
    static Map designCategories = new HashMap();

    @Override
    public boolean registerCarpentryWood(int index, ICarpentryWood wood) {
        if (wood != null) {
            return woodMap.put(index, wood) == null;
        }
        return false;
    }

    @Override
    public int getCarpentryWoodIndex(ICarpentryWood wood) {
        for (Integer integer : woodMap.keySet()) {
            if (!((ICarpentryWood)woodMap.get(integer)).equals(wood)) continue;
            return integer;
        }
        return -1;
    }

    @Override
    public ICarpentryWood getCarpentryWood(int index) {
        return (ICarpentryWood)woodMap.get(index);
    }

    @Override
    public boolean registerDesign(int index, IDesign wood) {
        if (wood != null) {
            return designMap.put(index, wood) == null;
        }
        return false;
    }

    @Override
    public int getDesignIndex(IDesign wood) {
        for (Integer integer : designMap.keySet()) {
            if (!((IDesign)designMap.get(integer)).equals(wood)) continue;
            return integer;
        }
        return -1;
    }

    @Override
    public IDesign getDesign(int index) {
        return (IDesign)designMap.get(index);
    }

    @Override
    public ICarpentryWood getCarpentryWood(ItemStack plank) {
        if (plank == null) {
            return null;
        }
        for (Map.Entry entry : woodMap.entrySet()) {
            ItemStack key = ((ICarpentryWood)entry.getValue()).getPlank();
            if (key == null || !key.func_77969_a(plank)) continue;
            return (ICarpentryWood)entry.getValue();
        }
        return null;
    }

    @Override
    public ILayout getLayout(IPattern pattern, boolean inverted) {
        return Layout.get(pattern, inverted);
    }

    @Override
    public boolean registerDesignCategory(IDesignCategory category) {
        if (category != null && category.getId() != null) {
            return designCategories.put(category.getId(), category) == null;
        }
        return false;
    }

    @Override
    public IDesignCategory getDesignCategory(String id) {
        return (IDesignCategory)designCategories.get(id);
    }

    @Override
    public Collection getAllDesignCategories() {
        ArrayList<IDesignCategory> categories = new ArrayList<IDesignCategory>();
        for (IDesignCategory category : designCategories.values()) {
            if (category.getDesigns().size() <= 0) continue;
            categories.add(category);
        }
        return categories;
    }

    @Override
    public List getSortedDesigns() {
        ArrayList designs = new ArrayList();
        for (IDesignCategory category : this.getAllDesignCategories()) {
            designs.addAll(category.getDesigns());
        }
        return designs;
    }
}

