/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.PlankType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockGate
extends BlockFenceGate
implements IBlockMetadata {
    public BlockGate(int id) {
        super(id);
        this.func_71849_a(Tabs.tabArboriculture);
        this.func_71894_b(5.0f);
        this.func_71848_c(2.0f);
        this.func_71884_a(field_71967_e);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (PlankType.ExtraTreePlanks extraTreePlanks : PlankType.ExtraTreePlanks.values()) {
            itemList.add(PlankType.getGate(extraTreePlanks));
        }
        for (Enum enum_ : PlankType.ForestryPlanks.values()) {
            itemList.add(PlankType.getGate((IPlankType)((Object)enum_)));
        }
        for (Enum enum_ : PlankType.ExtraBiomesPlank.values()) {
            if (enum_.getPlank() == null) continue;
            itemList.add(PlankType.getGate((IPlankType)((Object)enum_)));
        }
        for (Enum enum_ : PlankType.VanillaPlanks.values()) {
            itemList.add(PlankType.getGate((IPlankType)((Object)enum_)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, x, y, z);
        if (tile != null) {
            return this.func_71858_a(side, tile.getTileMetadata());
        }
        return super.func_71895_b(world, x, y, z, side);
    }

    public Icon func_71858_a(int side, int meta) {
        return PlankType.getPlank(meta).getIcon();
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack drop) {
        this.func_71929_a(world, x, y, z, drop);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_72274_a(World var1) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_71883_b(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_71883_b(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_72796_p(par2, par3, par4);
        return tileentity != null ? tileentity.func_70315_b(par5, par6) : false;
    }

    @Override
    public int getPlacedMeta(ItemStack stack, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        return TileEntityMetadata.getItemDamage(stack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack par1ItemStack) {
        int meta = TileEntityMetadata.getItemDamage(par1ItemStack);
        return PlankType.getPlank(meta).getName() + " Gate";
    }

    @Override
    public void getBlockTooltip(ItemStack par1ItemStack, List par3List) {
    }

    @Override
    public int getBlockID() {
        return this.field_71990_ca;
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_72932_q(par2, par3, par4);
    }
}

