/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.power.ErrorState;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.engineering.ModuleEngineering;
import binnie.extrabees.machines.logic.SlotValidatorSerum;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.ITankContainer;

public class TileEntityReplicator
extends TileEntityMachine
implements ITankContainer,
IInventory,
IPowerReceptor {
    public static final int SlotSerum = 2;
    public static final int SlotSerumEmpty = 3;
    public static final int[] SlotSerumsDone = new int[]{4, 5, 6, 7, 8, 9};

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Replicator;
    }

    public TileEntityReplicator() {
        super("Replicator", 25000, 500, 40000);
        this.addSlot(2, InventorySlot.NameInput);
        this.getSlot(2).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Serum));
        this.getSlot(2).setOutputSides(MachineSide.TopAndBottom);
        this.addSlot(3, "Vial Slot");
        this.getSlot(3).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Empty));
        this.getSlot(3).forbidExtraction();
        this.addSlotArray(SlotSerumsDone, InventorySlot.NameOutput);
        for (int slot : SlotSerumsDone) {
            this.getSlot(slot).setReadOnly();
            this.getSlot(slot).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Serum));
            this.getSlot(slot).setOutputSides(MachineSide.Sides);
        }
    }

    public InventorySlot[] getFreeVialSlots() {
        ArrayList<InventorySlot> slots = new ArrayList<InventorySlot>();
        for (InventorySlot slot : this.getSlots(SlotSerumsDone)) {
            if (slot.getItemStack() != null) continue;
            slots.add(slot);
        }
        return slots.toArray(new InventorySlot[0]);
    }

    @Override
    public void onFinishTask() {
        ItemStack original = this.getSlot(2).getItemStack();
        ModuleEngineering.changeQuality(original, -this.field_70331_k.field_73012_v.nextInt(2));
        ItemStack duplicate = original.func_77946_l();
        duplicate.func_77964_b(duplicate.func_77958_k());
        this.getSlot(3).decrStackSize(1);
        this.getFreeVialSlots()[0].setItemStack(duplicate);
    }

    @Override
    public ErrorState canWork() {
        if (this.getSlot(2).getItemStack() == null) {
            return new ErrorState.NoItem("No Serum to replicate", 2);
        }
        if (this.getSlot(3).getItemStack() == null) {
            return new ErrorState.NoItem("No Empty Serums to fill", 3);
        }
        if (this.getFreeVialSlots().length == 0) {
            return new ErrorState.NoSpace("No free vial slots", SlotSerumsDone);
        }
        return super.canWork();
    }

    @Override
    public String getInformation() {
        return "The Replicator copies alleles from a serum vial into other empty serum vials.";
    }
}

