/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.base.TileEntityMachineBase;
import binnie.core.machines.component.IBuildcraft;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ITankMachine;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceManager;
import binnie.core.resource.ResourceType;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.craftgui.minecraft.INetworkedEntityGUI;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.machines.tile.ComponentExtraBeeProcess;
import buildcraft.api.gates.IAction;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityMachine
extends TileEntityMachineBase
implements IBuildcraft.ActionProvider,
IBuildcraft.TriggerProvider,
INetworkedEntityGUI,
IMachine,
IMachineInformation,
INetwork.CraftGUIAction {
    IInventoryMachine inventory = null;
    ITankMachine tanks = null;
    IPoweredMachine power = null;
    IProcess process = null;
    ComponentInventoryTransfer transfer = null;
    public BinnieResource texture;
    int nextGuiID = 3;
    boolean dropped = false;
    boolean destroyed = false;
    List components = new ArrayList();
    int progressID = 242;

    public TileEntityMachine(String name) {
        this.texture = ResourceManager.getPNG(ExtraBees.instance, ResourceType.Tile, name);
        this.inventory = new ComponentInventorySlots(this);
        this.tanks = new ComponentTankContainer(this);
        this.power = new ComponentPowerReceptor(this);
        this.transfer = new ComponentInventoryTransfer(this);
        this.getPower().setConfig(1, 5, 10, 25, 5000);
    }

    @Override
    public IInventoryMachine getInventory() {
        return this.inventory;
    }

    @Override
    public ITankMachine getTankContainer() {
        return this.tanks;
    }

    @Override
    public IPoweredMachine getPower() {
        return this.power;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public TileEntityMachine(String name, int energyUsed, int timeTaken, int maxEnergy) {
        this(name);
        this.process = new ComponentExtraBeeProcess(this, energyUsed, timeTaken);
        int maxEnergyPerTick = (int)(this.process.getEnergyPerTick() * 4.0f);
        int minEnergyPerTick = 2;
        if (BinnieCore.proxy.isDebug()) {
            maxEnergyPerTick = 1000;
            minEnergyPerTick = 2;
        }
        this.getPower().setConfig(10, minEnergyPerTick, maxEnergyPerTick, minEnergyPerTick, maxEnergy);
    }

    public ExtraBeeGUID getGUI() {
        return null;
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        for (MachineComponent component : this.components) {
            component.writeToNBT(nbttagcompound);
        }
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        for (MachineComponent component : this.components) {
            component.readFromNBT(nbttagcompound);
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!BinnieCore.proxy.isSimulating(this.field_70331_k)) {
            if (BinnieCore.proxy.isDebug()) {
                this.doFX(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 1.0f);
            }
            return;
        }
        for (MachineComponent component : this.components) {
            component.onUpdate();
        }
        this.onUpdate();
    }

    protected void onUpdate() {
    }

    public final void doFX(World world, int x, int y, int z, float efficiency) {
        this.onFX(world, x, y, z, efficiency);
    }

    public boolean canUpdate() {
        return true;
    }

    private final List getInventoryOnDestroy() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.dropped) {
            return list;
        }
        this.dropped = true;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item == null) continue;
            list.add(item.func_77946_l());
        }
        return list;
    }

    public void onBlockDestroy(World world, int x, int y, int z) {
        if (this.destroyed) {
            return;
        }
        for (MachineComponent component : this.components) {
            component.onDestruction();
        }
        this.destroyed = true;
    }

    protected boolean isServer() {
        return BinnieCore.proxy.isSimulating(this.field_70331_k);
    }

    @SideOnly(value=Side.CLIENT)
    public void onFX(World world, int x, int y, int z, float efficiency) {
    }

    @Override
    public final void actionActivated(IAction action) {
        for (MachineComponent component : this.components) {
            if (!(component instanceof IBuildcraft.ActionProvider)) continue;
            ((IBuildcraft.ActionProvider)((Object)component)).actionActivated(action);
        }
    }

    @Override
    public void getActions(List actions) {
        for (MachineComponent component : this.components) {
            if (!(component instanceof IBuildcraft.ActionProvider)) continue;
            ((IBuildcraft.ActionProvider)((Object)component)).getActions(actions);
        }
    }

    @Override
    public void getTriggers(List triggers) {
        for (MachineComponent component : this.components) {
            if (!(component instanceof IBuildcraft.TriggerProvider)) continue;
            ((IBuildcraft.TriggerProvider)((Object)component)).getTriggers(triggers);
        }
    }

    @Override
    public void addGUINetworkData(Map data) {
        for (MachineComponent component : this.components) {
            if (!(component instanceof INetworkedEntityGUI)) continue;
            ((INetworkedEntityGUI)((Object)component)).addGUINetworkData(data);
        }
    }

    @Override
    public void recieveGUINetworkData(int id, int data) {
        for (MachineComponent component : this.components) {
            if (!(component instanceof INetworkedEntityGUI)) continue;
            ((INetworkedEntityGUI)((Object)component)).recieveGUINetworkData(id, data);
        }
    }

    @Override
    public void addComponent(MachineComponent component) {
        this.components.add(component);
    }

    @Override
    public MachineUtil getMachineUtil() {
        return new MachineUtil(this);
    }

    @Override
    public Object getInterface(Class interfac) {
        for (MachineComponent component : this.components) {
            if (!interfac.isInstance(component)) continue;
            return interfac.cast(component);
        }
        if (interfac.isInstance(this)) {
            return interfac.cast(this);
        }
        return null;
    }

    @Override
    public void onInventoryUpdate() {
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public String getInformation() {
        return "No Machine Information Found";
    }

    @Override
    public int getUniqueProgressBarID() {
        return this.progressID++;
    }

    public ErrorState canWork() {
        return null;
    }

    public ErrorState canProgress() {
        return null;
    }

    public void onFinishTask() {
    }

    public String getProcessTooltip() {
        return "Processing";
    }

    @Override
    public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        for (MachineComponent component : this.components) {
            if (!(component instanceof INetwork.CraftGUIAction)) continue;
            ((INetwork.CraftGUIAction)((Object)component)).recieveNBT(side, player, action);
        }
    }
}

