/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.block;

import binnie.core.BinnieCore;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.machines.ModuleMachines;
import binnie.extrabees.machines.block.BlockGeneticMachine;
import binnie.extrabees.machines.tile.TileEntityAdvancedGeneticMachine;
import binnie.extrabees.machines.tile.TileEntityInoculator;
import binnie.extrabees.machines.tile.TileEntityIsolator;
import binnie.extrabees.machines.tile.TileEntityMachine;
import binnie.extrabees.machines.tile.TileEntityPurifier;
import binnie.extrabees.machines.tile.TileEntityReplicator;
import binnie.extrabees.machines.tile.TileEntitySynthesizer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockAdvancedGeneticMachine
extends BlockGeneticMachine {
    @Override
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.getNumberOfMachines(); ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public BlockAdvancedGeneticMachine(int id) {
        super(id);
        this.func_71864_b("advGeneticMachine");
        this.func_71848_c(1.5f);
    }

    @Override
    public boolean func_71926_d() {
        return false;
    }

    @Override
    public boolean func_71886_c() {
        return false;
    }

    @Override
    public int func_71857_b() {
        return ModuleMachines.modelMachine;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            return true;
        }
        if (!BinnieCore.proxy.isSimulating(world)) {
            return true;
        }
        TileEntity entity = world.func_72796_p(x, y, z);
        if (entity instanceof TileEntityMachine) {
            ExtraBees.proxy.openGui(((TileEntityMachine)entity).getGUI(), player, x, y, z);
        }
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 1: {
                return new TileEntityIsolator();
            }
            case 2: {
                return new TileEntityReplicator();
            }
            case 3: {
                return new TileEntityPurifier();
            }
            case 4: {
                return new TileEntityInoculator();
            }
            case 5: {
                return new TileEntitySynthesizer();
            }
        }
        return new TileEntityAdvancedGeneticMachine();
    }

    @Override
    public String getMachineName(int meta) {
        switch (meta) {
            case 0: {
                return "Advanced Genetic Machine";
            }
            case 1: {
                return "Isolator";
            }
            case 2: {
                return "Replicator";
            }
            case 3: {
                return "Purifier";
            }
            case 4: {
                return "Inoculator";
            }
            case 5: {
                return "Synthesizer";
            }
        }
        return "??? Machine";
    }

    @Override
    public int getNumberOfMachines() {
        return Machine.values().length + 1;
    }

    @Override
    public int func_71899_b(int par1) {
        return par1;
    }

    static enum Machine {
        Isolator,
        Replicator,
        Purifier,
        Inoculator,
        Synthesizer;

    }
}

