/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.liquids;

import binnie.core.Binnie;
import binnie.core.language.LocalisedString;
import binnie.core.liquid.ILiquidType;
import binnie.core.liquid.ItemLiquid;
import binnie.core.liquid.ItemLiquidContainer;
import binnie.core.liquid.LiquidContainer;
import binnie.core.liquid.LiquidManager;
import binnie.extrabees.ExtraBees;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidStack;

public enum ExtraBeeLiquid implements ILiquidType
{
    ACID("Acid", "acid", 11528985),
    POISON("Poison", "poison", 15406315),
    GLACIAL("Liquid Nitrogen", "liquidNitrogen", 9881800);

    public LocalisedString name;
    String ident;
    Icon icon;
    int colour;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ExtraBeeLiquid(int name) {
        void colour;
        void ident;
        this.name = Binnie.Language.register(ExtraBees.instance, "liquid" + this.toString().toLowerCase(), (String)name);
        this.ident = ident;
        this.colour = colour;
    }

    @Override
    public boolean canBePlacedInContainer(LiquidContainer container) {
        return true;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcon(IconRegister register) {
        this.icon = ExtraBees.proxy.getIcon(register, "liquids/" + this.getIdentifier());
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public void setItem(ItemLiquid itemLiquid) {
        ExtraBees.liquid = itemLiquid;
    }

    @Override
    public void setContainerItem(ItemLiquidContainer itemContainer) {
        ExtraBees.liquidContainer = itemContainer;
    }

    @Override
    public String getIdentifier() {
        return this.ident;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public LiquidStack get(int amount) {
        return LiquidManager.getLiquidStack(this.ident, amount);
    }
}

