/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.effect;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FireworkCreator {

    public static class Firework {
        boolean flicker = false;
        boolean trail = false;
        ArrayList colors = new ArrayList();
        byte shape = 0;

        public void setFlicker() {
            this.flicker = true;
        }

        public void setTrail() {
            this.trail = true;
        }

        public void setShape(Shape shape) {
            this.shape = (byte)shape.ordinal();
        }

        public void addColor(int color) {
            this.colors.add(color);
        }

        NBTTagCompound getNBT() {
            NBTTagCompound nbt = new NBTTagCompound("Explosion");
            if (this.flicker) {
                nbt.func_74757_a("Flicker", true);
            }
            if (this.trail) {
                nbt.func_74757_a("Trail", true);
            }
            if (this.colors.size() == 0) {
                this.addColor(0xFFFFFF);
            }
            int[] array = new int[this.colors.size()];
            for (int i = 0; i < this.colors.size(); ++i) {
                array[i] = (Integer)this.colors.get(i);
            }
            nbt.func_74783_a("Colors", array);
            nbt.func_74774_a("Type", this.shape);
            return nbt;
        }

        public ItemStack getFirework() {
            NBTTagCompound var15 = new NBTTagCompound();
            NBTTagCompound var18 = new NBTTagCompound("Fireworks");
            NBTTagList var25 = new NBTTagList("Explosions");
            var25.func_74742_a((NBTBase)this.getNBT());
            var18.func_74782_a("Explosions", (NBTBase)var25);
            var18.func_74774_a("Flight", (byte)0);
            var15.func_74782_a("Fireworks", (NBTBase)var18);
            ItemStack item = new ItemStack(Item.field_92104_bU);
            item.func_77982_d(var15);
            return item;
        }
    }

    public static enum Shape {
        Ball,
        LargeBall,
        Star,
        Creeper,
        Burst;

    }
}

