/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.engineering;

import binnie.core.genetics.BinnieGenetics;
import binnie.core.plugin.IBinnieModule;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.config.ConfigurationMachines;
import binnie.extrabees.config.ConfigurationMain;
import binnie.extrabees.engineering.ItemSerum;
import binnie.extrabees.engineering.ItemSerumEmpty;
import binnie.extrabees.engineering.ItemTemplate;
import binnie.extrabees.engineering.ItemTemplateBlank;
import binnie.extrabees.genetics.effect.EnumExtraBeeEffect;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ModuleEngineering
implements IBinnieModule {
    static Random rand = new Random();

    @Override
    public void preInit() {
        ExtraBees.template = new ItemTemplate(ConfigurationMain.templateID);
        ExtraBees.templateBlank = new ItemTemplateBlank(ConfigurationMain.templateBlankID);
        ExtraBees.serum = new ItemSerum(ConfigurationMain.serumID);
        ExtraBees.serumEmpty = new ItemSerumEmpty(ConfigurationMain.serumEmptyID);
    }

    @Override
    public void doInit() {
    }

    @Override
    public void postInit() {
    }

    public static void changeQuality(ItemStack itemStack, int dif) {
        if (itemStack == null) {
            return;
        }
        if (!itemStack.func_77942_o()) {
            return;
        }
        if (dif == 0) {
            return;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        int q = nbt.func_74762_e("quality");
        if ((q += dif) > 10) {
            q = 10;
        }
        if (q < 0) {
            q = 0;
        }
        nbt.func_74768_a("quality", q);
        itemStack.func_77982_d(nbt);
    }

    public static int getColour(IAllele allele, EnumBeeChromosome chromosome, int pass) {
        switch (chromosome) {
            case SPECIES: {
                if (pass == 1) {
                    return 10237237;
                }
                if (pass != 3) break;
                return ((IAlleleBeeSpecies)allele).getIconColour(0);
            }
            case CAVE_DWELLING: {
                if (pass != 0 && pass != 1 && pass != 3) break;
                return 9803420;
            }
            case EFFECT: {
                if (pass != 1) break;
                return 11775522;
            }
            case FERTILITY: {
                if (pass != 1) break;
                return 14696881;
            }
            case FLOWERING: {
                if (pass != 1) break;
                return 11756986;
            }
            case FLOWER_PROVIDER: {
                if (pass != 1) break;
                return 5808999;
            }
            case HUMIDITY: {
                break;
            }
            case HUMIDITY_TOLERANCE: {
                if (pass != 1) break;
                return 2206148;
            }
            case LIFESPAN: {
                if (pass != 1) break;
                return 4958648;
            }
            case NOCTURNAL: {
                if (pass != 0 && pass != 1 && pass != 3) break;
                return 2106716;
            }
            case SPEED: {
                if (pass != 1) break;
                return 12042007;
            }
            case TEMPERATURE_TOLERANCE: {
                if (pass != 1) break;
                return 9057846;
            }
            case TERRITORY: {
                if (pass != 1) break;
                return 3484328;
            }
            case TOLERANT_FLYER: {
                if (pass != 0 && pass != 1 && pass != 3) break;
                return 4147105;
            }
        }
        return -1;
    }

    public static String getName(IAllele allele, EnumBeeChromosome chromosome) {
        switch (chromosome) {
            case SPECIES: {
                return ((IAlleleSpecies)allele).getName() + " Species";
            }
            case CAVE_DWELLING: {
                return "Cave Dwelling";
            }
            case EFFECT: {
                IAlleleBeeEffect eAllele = (IAlleleBeeEffect)allele;
                if (eAllele.getName() != null && eAllele.getName().equals("None")) {
                    return "Effect Cancelation";
                }
                return eAllele.getName() + " Effect";
            }
            case FERTILITY: {
                for (Fertility lspan : Fertility.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName();
                }
                break;
            }
            case FLOWERING: {
                for (Flowering lspan : Flowering.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName();
                }
                break;
            }
            case FLOWER_PROVIDER: {
                IAlleleFlowers fAllele = (IAlleleFlowers)allele;
                if (allele.getUID().equals("extrabees.flower.none")) {
                    return "Non-pollination";
                }
                return fAllele.getProvider().getDescription() + " Pollination";
            }
            case HUMIDITY: {
                for (Speed lspan : Speed.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName();
                }
                break;
            }
            case HUMIDITY_TOLERANCE: {
                for (Tolerance lspan : Tolerance.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName("Humid.");
                }
                break;
            }
            case LIFESPAN: {
                for (Lifespan lspan : Lifespan.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName();
                }
                break;
            }
            case NOCTURNAL: {
                return "Nocturnal";
            }
            case SPEED: {
                for (Speed lspan : Speed.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName();
                }
                break;
            }
            case TEMPERATURE_TOLERANCE: {
                for (Tolerance lspan : Tolerance.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName("Temp.");
                }
                break;
            }
            case TERRITORY: {
                for (Territory lspan : Territory.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return lspan.getName();
                }
                break;
            }
            case TOLERANT_FLYER: {
                return "Rainfall";
            }
        }
        return "Corrupted";
    }

    public static void getQualityInfo(ItemStack itemStack, List list) {
        int quality = ModuleEngineering.getQuality(itemStack);
        Quality type = Quality.Average;
        switch (quality) {
            case 0: 
            case 1: {
                type = Quality.Awful;
                break;
            }
            case 2: 
            case 3: {
                type = Quality.Poor;
                break;
            }
            case 7: 
            case 8: {
                type = Quality.Good;
                break;
            }
            case 9: 
            case 10: {
                type = Quality.Excellent;
                break;
            }
        }
        list.add(type.color + "\u00a7o" + type.toString() + " Quality \u00a7r");
    }

    public static int getQuality(ItemStack item) {
        if (!item.func_77942_o()) {
            return 0;
        }
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt.func_74764_b("quality")) {
            return nbt.func_74762_e("quality");
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection getAllSerums() {
        ItemStack serum;
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            void var4_6;
            String name = "DNA";
            Object var4_7 = null;
            if (allele instanceof IAlleleBeeSpecies) {
                EnumBeeChromosome enumBeeChromosome = EnumBeeChromosome.SPECIES;
                name = ((IAlleleSpecies)allele).getName();
            } else if (allele instanceof IAlleleBeeEffect) {
                EnumBeeChromosome enumBeeChromosome = EnumBeeChromosome.EFFECT;
                name = ((IAlleleEffect)allele).getName();
            } else if (allele instanceof IAlleleFlowers) {
                EnumBeeChromosome enumBeeChromosome = EnumBeeChromosome.FLOWER_PROVIDER;
                name = ((IAlleleFlowers)allele).getProvider().getDescription();
            }
            if (name == "DNA") continue;
            itemList.add(ModuleEngineering.createSerum(allele, (EnumBeeChromosome)var4_6, 5));
        }
        for (Lifespan lifespan : Lifespan.values()) {
            serum = ModuleEngineering.tryCreateSerum(AlleleManager.alleleRegistry.getAllele(lifespan.getUID()), EnumBeeChromosome.LIFESPAN, 5);
            if (serum == null) continue;
            itemList.add(serum);
        }
        for (Enum enum_ : Flowering.values()) {
            serum = ModuleEngineering.tryCreateSerum(AlleleManager.alleleRegistry.getAllele(((Flowering)enum_).getUID()), EnumBeeChromosome.FLOWERING, 5);
            if (serum == null) continue;
            itemList.add(serum);
        }
        for (Enum enum_ : Fertility.values()) {
            serum = ModuleEngineering.tryCreateSerum(AlleleManager.alleleRegistry.getAllele(((Fertility)enum_).getUID()), EnumBeeChromosome.FERTILITY, 5);
            if (serum == null) continue;
            itemList.add(serum);
        }
        for (Enum enum_ : Territory.values()) {
            serum = ModuleEngineering.tryCreateSerum(AlleleManager.alleleRegistry.getAllele(((Territory)enum_).getUID()), EnumBeeChromosome.TERRITORY, 5);
            if (serum == null) continue;
            itemList.add(serum);
        }
        for (Enum enum_ : Speed.values()) {
            serum = ModuleEngineering.tryCreateSerum(AlleleManager.alleleRegistry.getAllele(((Speed)enum_).getUID()), EnumBeeChromosome.SPEED, 5);
            if (serum == null) continue;
            itemList.add(serum);
        }
        for (Enum enum_ : Tolerance.values()) {
            serum = ModuleEngineering.tryCreateSerum(AlleleManager.alleleRegistry.getAllele(((Tolerance)enum_).getUID()), EnumBeeChromosome.TEMPERATURE_TOLERANCE, 5);
            ItemStack serum2 = ModuleEngineering.tryCreateSerum(AlleleManager.alleleRegistry.getAllele(((Tolerance)enum_).getUID()), EnumBeeChromosome.HUMIDITY_TOLERANCE, 5);
            if (serum != null) {
                itemList.add(serum);
            }
            if (serum2 == null) continue;
            itemList.add(serum2);
        }
        itemList.add(ModuleEngineering.createSerum(AlleleManager.alleleRegistry.getAllele("boolTrue"), EnumBeeChromosome.NOCTURNAL, 5));
        itemList.add(ModuleEngineering.createSerum(AlleleManager.alleleRegistry.getAllele("boolTrue"), EnumBeeChromosome.CAVE_DWELLING, 5));
        itemList.add(ModuleEngineering.createSerum(AlleleManager.alleleRegistry.getAllele("boolTrue"), EnumBeeChromosome.TOLERANT_FLYER, 5));
        return itemList;
    }

    public static ItemStack tryCreateSerum(IAllele allele, EnumBeeChromosome chromosome, int quality) {
        if (allele == null || chromosome == null) {
            return null;
        }
        switch (chromosome) {
            case SPECIES: {
                if (allele instanceof IAlleleBeeSpecies) {
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case CAVE_DWELLING: {
                if (allele.getUID().equals("forestry.boolTrue")) {
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case EFFECT: {
                if (allele instanceof IAlleleBeeEffect) {
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case FERTILITY: {
                for (Fertility lspan : Fertility.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case FLOWERING: {
                for (Flowering lspan : Flowering.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case FLOWER_PROVIDER: {
                if (allele instanceof IAlleleFlowers) {
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case HUMIDITY: {
                return null;
            }
            case HUMIDITY_TOLERANCE: 
            case TEMPERATURE_TOLERANCE: {
                for (Tolerance lspan : Tolerance.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case LIFESPAN: {
                for (Lifespan lspan : Lifespan.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case NOCTURNAL: {
                if (allele.getUID().equals("forestry.boolTrue")) {
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case SPEED: {
                for (Speed lspan : Speed.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case TERRITORY: {
                for (Territory lspan : Territory.values()) {
                    if (!lspan.getUID().equals(allele.getUID())) continue;
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
            case TOLERANT_FLYER: {
                if (allele.getUID().equals("forestry.boolTrue")) {
                    return ModuleEngineering.createSerum(allele, chromosome, quality);
                }
                return null;
            }
        }
        return null;
    }

    public static ItemStack createSerum(IAllele allele, EnumBeeChromosome chromosome, int quality) {
        if (AlleleManager.alleleRegistry.isBlacklisted(allele.getUID())) {
            return null;
        }
        int i = chromosome.ordinal();
        if (i > EnumBeeChromosome.HUMIDITY.ordinal()) {
            --i;
        }
        ItemStack stack = new ItemStack(ExtraBees.serum, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("quality", quality);
        nbt.func_74778_a("uid", allele.getUID());
        nbt.func_74768_a("chromosome", i);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static Collection getAllGenomes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            IAllele[] template = BinnieGenetics.getBeeRoot().getTemplate(allele.getUID());
            if (template == null) continue;
            IBeeGenome genome = BinnieGenetics.getBeeRoot().templateAsGenome(template);
            NBTTagCompound nbt = new NBTTagCompound();
            genome.writeToNBT(nbt);
            NBTTagCompound itemNBT = new NBTTagCompound();
            itemNBT.func_74766_a("genome", nbt);
            itemNBT.func_74768_a("quality", 5);
            ItemStack item = new ItemStack(ExtraBees.genome, 1, 0);
            item.func_77982_d(itemNBT);
            list.add(item);
        }
        return list;
    }

    public static void doBadStuff(ItemStack beeStack, ItemStack engineeringItem) {
        int quality = ModuleEngineering.getQuality(engineeringItem);
        double severityD = 50 - quality * 10 + rand.nextInt(50);
        int severity = (int)(severityD *= ConfigurationMachines.geneticErrorModifier);
        if (severity <= 0) {
            return;
        }
        if (severity > 100) {
            severity = 100;
        }
        if (severity > 50 && rand.nextInt(101 - severity) < 10) {
            IBee bee = ModuleEngineering.getBee(beeStack);
            bee.setIsNatural(false);
            ModuleEngineering.setBee(beeStack, bee);
        }
        if (severity > 40 && rand.nextInt(101 - severity) < 25) {
            ModuleEngineering.alterAllele(beeStack, EnumBeeChromosome.FERTILITY, rand.nextInt(2), "forestry.fertilityLow");
        }
        if (severity > 30 && rand.nextInt(101 - severity) < 25) {
            ModuleEngineering.alterAllele(beeStack, EnumBeeChromosome.SPEED, rand.nextInt(2), "forestry.speedSlowest");
        }
        if (severity > 30 && rand.nextInt(101 - severity) < 25) {
            ModuleEngineering.alterAllele(beeStack, EnumBeeChromosome.LIFESPAN, rand.nextInt(2), "forestry.lifespanShortest");
        }
        if (severity > 15 && rand.nextInt(101 - severity) < 25) {
            ModuleEngineering.alterAllele(beeStack, EnumBeeChromosome.HUMIDITY_TOLERANCE, rand.nextInt(2), "forestry.toleranceNone");
        }
        if (severity > 15 && rand.nextInt(101 - severity) < 25) {
            ModuleEngineering.alterAllele(beeStack, EnumBeeChromosome.TEMPERATURE_TOLERANCE, rand.nextInt(2), "forestry.toleranceNone");
        }
        if (severity > 50 && rand.nextInt(101 - severity) < 15) {
            String[] effectUIDs = new String[]{"forestry.effectAggressive", "forestry.effectMiasmic", "forestry.effectIgnition", "forestry.effectAggressive", "forestry.effectMiasmic", "forestry.effectIgnition", EnumExtraBeeEffect.LIGHTNING.getUID(), EnumExtraBeeEffect.LIGHTNING.getUID(), EnumExtraBeeEffect.METEOR.getUID(), EnumExtraBeeEffect.METEOR.getUID(), EnumExtraBeeEffect.SPAWN_CREEPER.getUID(), EnumExtraBeeEffect.SPAWN_ZOMBIE.getUID(), EnumExtraBeeEffect.SPAWN_SKELETON.getUID()};
            ModuleEngineering.alterAllele(beeStack, EnumBeeChromosome.EFFECT, rand.nextInt(2), effectUIDs[rand.nextInt(effectUIDs.length)]);
        }
    }

    public static IBee getBee(ItemStack beeStack) {
        if (beeStack == null) {
            return null;
        }
        return BinnieGenetics.getBeeRoot().getMember(beeStack);
    }

    public static void setBee(ItemStack beeStack, IBee bee) {
        if (bee == null || beeStack == null) {
            return;
        }
        NBTTagCompound tag = beeStack.func_77978_p();
        bee.writeToNBT(tag);
    }

    public static void alterAllele(ItemStack beeStack, EnumBeeChromosome chromosome, int allele, String UID) {
        if (beeStack == null) {
            return;
        }
        if (AlleleManager.alleleRegistry.getAllele(UID) == null) {
            return;
        }
        int chromsomeID = chromosome.ordinal() >= EnumBeeChromosome.HUMIDITY.ordinal() ? chromosome.ordinal() - 1 : chromosome.ordinal();
        NBTTagCompound beeNBT = beeStack.func_77978_p();
        NBTTagCompound genomeNBT = beeNBT.func_74775_l("Genome");
        NBTTagList chromosomes = genomeNBT.func_74761_m("Chromosomes");
        NBTTagCompound chromosomeNBT = (NBTTagCompound)chromosomes.func_74743_b(chromsomeID);
        chromosomeNBT.func_74778_a("UID" + allele, UID);
        beeStack.func_77982_d(beeNBT);
    }

    public static void getCreativeTabSerums(List stacks) {
        ArrayList<IAlleleBeeSpecies> species = new ArrayList<IAlleleBeeSpecies>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies) || ((IAlleleBeeSpecies)allele).isSecret()) continue;
            species.add((IAlleleBeeSpecies)allele);
        }
        for (IAlleleBeeSpecies bSpecies : species) {
            ItemStack serum = ModuleEngineering.tryCreateSerum((IAllele)bSpecies, EnumBeeChromosome.SPECIES, 10);
            if (serum == null) continue;
            stacks.add(serum);
        }
    }

    public static enum Tolerance {
        None("No"),
        Both1("Both 1"),
        Both2("Both 2"),
        Both3("Both 3"),
        Both4("Both 4"),
        Both5("Both 5"),
        Up1("Up 1"),
        Up2("Up 2"),
        Up3("Up 3"),
        Up4("Up 4"),
        Up5("Up 5"),
        Down1("Down 1"),
        Down2("Down 2"),
        Down3("Down 3"),
        Down4("Down 4"),
        Down5("Down 5");

        String name;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Tolerance() {
            void name;
            this.name = name;
        }

        public String getUID() {
            return "forestry.tolerance" + this.toString();
        }

        public String getName(String type) {
            return this.name + " " + type + " Tol.";
        }
    }

    public static enum Territory {
        Default,
        Large,
        Larger,
        Largest;


        public String getUID() {
            return "forestry.territory" + this.toString();
        }

        public String getName() {
            return this.toString() + " Territory";
        }
    }

    public static enum Flowering {
        Slowest,
        Slower,
        Slow,
        Average,
        Fast,
        Faster,
        Fastest,
        Maximum;


        public String getUID() {
            return "forestry.flowering" + this.toString();
        }

        public String getName() {
            return this.toString() + " Flowering";
        }
    }

    public static enum Fertility {
        Low,
        Normal,
        High,
        Maximum;


        public String getUID() {
            return "forestry.fertility" + this.toString();
        }

        public String getName() {
            return this.toString() + " Fertility";
        }
    }

    public static enum Speed {
        Slowest,
        Slower,
        Slow,
        Norm,
        Fast,
        Faster,
        Fastest;


        public String getUID() {
            return "forestry.speed" + this.toString();
        }

        public String getName() {
            String name = this.toString();
            if (this == Norm) {
                name = name + "al";
            }
            return name + " Productivity";
        }
    }

    public static enum Lifespan {
        Shortest,
        Shorter,
        Short,
        Shortened,
        Normal,
        Elongated,
        Long,
        Longer,
        Longest;


        public String getUID() {
            return "forestry.lifespan" + this.toString();
        }

        public String getName() {
            return this.toString() + " Lifespan";
        }
    }

    static enum Quality {
        Awful("\u00a7c"),
        Poor("\u00a76"),
        Average("\u00a7e"),
        Good("\u00a7a"),
        Excellent("\u00a7b");

        String color;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Quality() {
            void color;
            this.color = color;
        }
    }
}

