/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.engineering;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.engineering.CreativeTabGenetics;
import binnie.extrabees.engineering.ItemTemplateBlank;
import binnie.extrabees.engineering.ModuleEngineering;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ItemTemplate
extends ItemTemplateBlank {
    Icon iconEdge;
    Icon iconFilling;

    public Icon func_77618_c(int par1, int par2) {
        return par2 > 0 ? this.iconEdge : this.iconFilling;
    }

    public boolean isRepairable() {
        return false;
    }

    public ItemTemplate(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77655_b("template");
        this.func_77637_a(CreativeTabGenetics.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        ModuleEngineering.getQualityInfo(itemStack, list);
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        int i = itemstack.func_77960_j();
        if (j > 0) {
            return 0xFFFFFF;
        }
        IAlleleBeeSpecies species = ItemTemplate.getSpecies(itemstack);
        if (species == null) {
            return 0xFFFFFF;
        }
        return species.getIconColour(0);
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        IAlleleBeeSpecies species = ItemTemplate.getSpecies(itemstack);
        if (species == null) {
            return "Corrupt Template";
        }
        return species.getName() + " Template";
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (ObtainableSpecies oSpecies : ObtainableSpecies.values()) {
            IAllele allele = AlleleManager.alleleRegistry.getAllele(oSpecies.uid);
            if (allele == null) continue;
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("quality", 5);
            nbt.func_74778_a("species", allele.getUID());
            stack.func_77982_d(nbt);
            itemList.add(stack);
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public static boolean canObtainSpecies(String uid) {
        for (ObtainableSpecies oSpecies : ObtainableSpecies.values()) {
            if (!oSpecies.uid.equals(uid)) continue;
            return true;
        }
        return false;
    }

    public static IAlleleBeeSpecies getSpecies(ItemStack template) {
        if (template == null || !template.func_77942_o()) {
            return null;
        }
        String uid = template.func_77978_p().func_74779_i("species");
        if (uid == "") {
            return null;
        }
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        return (IAlleleBeeSpecies)allele;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.iconEdge = ExtraBees.proxy.getIcon(register, "machines/template.edge");
        this.iconFilling = ExtraBees.proxy.getIcon(register, "machines/template.filling");
    }

    static enum ObtainableSpecies {
        FOREST("forestry.speciesForest"),
        MEADOWS("forestry.speciesMeadows"),
        MODEST("forestry.speciesModest"),
        TROPICAL("forestry.speciesTropical"),
        WINTRY("forestry.speciesWintry"),
        COMMON("forestry.speciesCommon"),
        WATER("extrabees.species.water"),
        ROCK("extrabees.species.rock");

        String uid;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ObtainableSpecies() {
            void uid;
            this.uid = uid;
        }
    }
}

