/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.PageSpecies;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.LinkedHashMap;
import java.util.Map;

public class PageSpeciesClassification
extends PageSpecies {
    Map levels = new LinkedHashMap();
    ControlText genus;

    public PageSpeciesClassification(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        int y = 16;
        for (IClassification.EnumClassLevel level : IClassification.EnumClassLevel.values()) {
            ControlTextCentered text = new ControlTextCentered((IWidget)this, y, "");
            text.setColour(level.getColour());
            this.levels.put(level, text);
            y += 12;
        }
        this.genus = new ControlTextCentered((IWidget)this, y, "");
        this.genus.setColour(16759415);
    }

    @Override
    public void onSpeciesChanged(IAlleleSpecies species) {
        if (species != null) {
            for (ControlText text : this.levels.values()) {
                text.setValue("- - -");
            }
            this.genus.setValue(species.getBinomial());
            for (IClassification classification = species.getBranch(); classification != null; classification = classification.getParent()) {
                IClassification.EnumClassLevel level = classification.getLevel();
                String text = "";
                int n = level.ordinal();
                text = text + classification.getScientific();
                ((ControlText)this.levels.get(level)).setValue(text);
            }
        }
    }
}

