/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.network.INetwork;
import binnie.core.network.packet.PacketCraftGUI;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceManager;
import binnie.core.resource.ResourceType;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.TopLevelWidget;
import binnie.craftgui.minecraft.ContainerCraftGUI;
import binnie.craftgui.minecraft.ControlHelp;
import binnie.craftgui.minecraft.ControlInfo;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.EnumHighlighting;
import binnie.craftgui.minecraft.GuiCraftGUI;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.WindowInventory;
import binnie.craftgui.resource.IStyleSheet;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.StyleSheetManager;
import binnie.craftgui.resource.minecraft.StandardTexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Window
extends TopLevelWidget
implements INetwork.CraftGUIAction {
    private GuiCraftGUI gui;
    private ContainerCraftGUI container;
    private WindowInventory windowInventory;
    private ControlText title;
    ITexture bgText1 = null;
    ITexture bgText2 = null;
    public boolean hasBeenInitialised = false;
    private EntityPlayer player;
    private IInventory entityInventory;
    Side side = Side.CLIENT;
    protected IStyleSheet stylesheet;

    public void getTooltip(Tooltip tooltip) {
        if (this.getMousedOverWidget() instanceof ITooltip) {
            ((ITooltip)((Object)this.getMousedOverWidget())).getTooltip(tooltip);
        }
    }

    protected abstract IBinnieMod getMod();

    protected abstract String getName();

    public BinnieResource getBackgroundTextureFile(int i) {
        return ResourceManager.getPNG(this.getMod(), ResourceType.GUI, this.getName() + (i == 1 ? "" : Integer.valueOf(i)));
    }

    public Window(float width, float height, EntityPlayer player, IInventory inventory, Side side) {
        this.side = side;
        this.setInventories(player, inventory);
        this.container = new ContainerCraftGUI(this);
        this.windowInventory = new WindowInventory(this);
        if (!this.isServer()) {
            this.gui = new GuiCraftGUI(this, width, height);
            this.setRenderer(this.gui);
            this.stylesheet = StyleSheetManager.getDefault();
        }
        int by = 4;
        int bx = -18;
        if (Machine.getInterface(IInventoryMachine.class, this.getInventory()) != null) {
            ControlHelp controlHelp = new ControlHelp(this, bx += 22, by);
        }
        if (Machine.getInterface(IMachineInformation.class, this.getInventory()) != null) {
            ControlInfo controlInfo = new ControlInfo(this, bx += 22, by);
        }
    }

    public void setTitle(String title) {
        if (this.title != null) {
            this.title.setValue(title);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final GuiCraftGUI getGui() {
        return this.gui;
    }

    public final ContainerCraftGUI getContainer() {
        return this.container;
    }

    public final WindowInventory getWindowInventory() {
        return this.windowInventory;
    }

    public final void initGui() {
        if (this.hasBeenInitialised) {
            return;
        }
        this.title = new ControlTextCentered((IWidget)this, 9.0f, " ");
        this.title.setColour(0x404040);
        this.bgText1 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(1));
        if (this.getSize().x() > 256.0f) {
            this.bgText2 = new StandardTexture(0, 0, 256, 256, this.getBackgroundTextureFile(2));
        }
        this.initialize();
        this.hasBeenInitialised = true;
    }

    public abstract void initialize();

    @Override
    public void onRenderBackground() {
        ((IRendererMinecraft)this.getRenderer(IRendererMinecraft.class)).renderWindow(this);
    }

    @Override
    public void onRenderForeground() {
    }

    @Override
    public void onRenderOverlay() {
    }

    @Override
    public void onUpdate() {
        ((List)ControlSlot.highlighting.get((Object)EnumHighlighting.Help)).clear();
        ((List)ControlSlot.highlighting.get((Object)EnumHighlighting.ShiftClick)).clear();
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public ItemStack getHeldItemStack() {
        if (this.player != null) {
            return this.player.field_71071_by.func_70445_o();
        }
        return null;
    }

    public IInventory getInventory() {
        return this.entityInventory;
    }

    public void setInventories(EntityPlayer player2, IInventory inventory) {
        this.player = player2;
        this.entityInventory = inventory;
    }

    public void onClose() {
    }

    public void setHeldItemStack(ItemStack stack) {
        if (this.player != null) {
            this.player.field_71071_by.func_70437_b(stack);
        }
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public boolean isClient() {
        return this.side == Side.CLIENT;
    }

    public World getWorld() {
        if (this.getPlayer() != null) {
            return this.getPlayer().field_70170_p;
        }
        return BinnieCore.proxy.getWorld();
    }

    public void onInventoryUpdate() {
    }

    public void sendClientAction(NBTTagCompound action) {
        PacketCraftGUI packet = new PacketCraftGUI(action);
        BinnieCore.proxy.sendToServer(BinnieCore.instance, packet);
    }

    @Override
    public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
    }

    @Override
    public ITexture getTexture(Object key) {
        return this.stylesheet.getTexture(key);
    }

    public void onWindowInventoryChanged() {
    }

    public ITexture getBackground1() {
        return this.bgText1;
    }

    public ITexture getBackground2() {
        return this.bgText2;
    }

    public static Window get(IWidget widget) {
        return (Window)widget.getSuperParent();
    }
}

