/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.TankInfo;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class ControlLiquidTank
extends Control
implements ITooltip {
    public static List tankError = new ArrayList();
    protected int tankID;

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onMouseClick(EventMouse.Down event) {
        if (event.getButton() == 0) {
            NBTTagCompound nbt = new NBTTagCompound("tank-click");
            nbt.func_74774_a("id", (byte)this.tankID);
            Window.get(this).sendClientAction(nbt);
        }
    }

    public ControlLiquidTank(IWidget parent, int x, int y) {
        super(parent, x, y, 18.0f, 60.0f);
        this.canMouseOver = true;
    }

    public void setTankID(int tank) {
        this.tankID = tank;
    }

    public TankInfo getTank() {
        return Window.get(this).getContainer().getTankInfo(this.tankID);
    }

    public boolean isTankValid() {
        return !this.getTank().isEmpty();
    }

    public int getTankCapacity() {
        return (int)this.getTank().getCapacity();
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)CraftGUITexture.LiquidTank, Vector2f.ZERO);
        if (this.isMouseOver() && Window.get(this).getGui().getTooltipType() == Tooltip.Type.Help) {
            int c = -1442840576 + MinecraftTooltip.getOutline(Tooltip.Type.Help);
            this.getRenderer().renderGradientRect(new Area(1.0f, 1.0f, 16.0f, 58.0f), c, c);
        } else if (tankError.contains(this.tankID)) {
            int c = -1442840576 + MinecraftTooltip.getOutline(MinecraftTooltip.Type.Error);
            this.getRenderer().renderGradientRect(new Area(1.0f, 1.0f, 16.0f, 58.0f), c, c);
        } else if (this.getSuperParent().getMousedOverWidget() == this) {
            if (Window.get(this).getGui().getDraggedItem() != null) {
                this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), -1426089575, -1426089575);
            } else {
                this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), -2130706433, -2130706433);
            }
        }
    }

    @Override
    public void onRenderForeground() {
        if (this.isTankValid()) {
            Object content = null;
            int squaled = (int)(58.0 * (double)(this.getTank().getAmount() / this.getTank().getCapacity()));
            int yPos = 59;
            int block = Math.min(squaled, 16);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IPosition pos = this.getAbsolutePosition();
            IArea limited = CraftGUIUtil.getPaddedArea(this.getArea(), 1);
            this.getRenderer().limitArea(new Area(limited.pos().add(pos), limited.size()));
            GL11.glEnable((int)3089);
            while (block > 0) {
                ((IRendererMinecraft)this.getRenderer().subRenderer(IRendererMinecraft.class)).renderItem(new Vector2f(1.0f, yPos - block), this.getTank().liquid.asItemStack());
                yPos -= 16;
                block = Math.min(squaled -= 16, 16);
            }
            GL11.glDisable((int)3089);
        }
    }

    @Override
    public void onRenderOverlay() {
        IArea area;
        this.getRenderer().renderTexture((Object)CraftGUITexture.LiquidTankOverlay, Vector2f.ZERO);
        if (this.isMouseOver() && Window.get(this).getGui().getTooltipType() == Tooltip.Type.Help) {
            area = this.getArea();
            this.getRenderer().setColour(MinecraftTooltip.getOutline(Tooltip.Type.Help));
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, CraftGUIUtil.getPaddedArea(area, -1));
        }
        if (tankError.contains(this.tankID)) {
            area = this.getArea();
            this.getRenderer().setColour(MinecraftTooltip.getOutline(MinecraftTooltip.Type.Error));
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, CraftGUIUtil.getPaddedArea(area, -1));
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (tooltip.getType() == Tooltip.Type.Help && this.getTankSlot() != null) {
            TankSlot slot = this.getTankSlot();
            tooltip.add(slot.getName());
            tooltip.add("Insert Side: " + MachineSide.asString(slot.getInputSides()));
            tooltip.add("Extract Side: " + MachineSide.asString(slot.getOutputSides()));
            if (slot.isReadOnly()) {
                tooltip.add("Output Only Tank");
            }
            tooltip.add("Accepts: " + (slot.getValidator() == null ? "Any Item" : slot.getValidator().getTooltip()));
            return;
        }
        if (this.isTankValid()) {
            int percentage = (int)(100.0 * (double)this.getTank().getAmount() / (double)this.getTankCapacity());
            tooltip.add(this.getTank().getName());
            tooltip.add(percentage + "% full");
            return;
        }
        tooltip.add("Empty");
        tooltip.add("0% full");
    }

    private TankSlot getTankSlot() {
        ITankMachine tank = (ITankMachine)Machine.getInterface(ITankMachine.class, Window.get(this).getInventory());
        return tank != null ? tank.getTankSlot(this.tankID) : null;
    }
}

