/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateSource;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.machines.power.TankInfo;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.network.packet.PacketCraftGUI;
import binnie.core.network.packet.PacketErrorUpdate;
import binnie.core.network.packet.PacketPowerUpdate;
import binnie.core.network.packet.PacketTankUpdate;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.CustomSlot;
import binnie.craftgui.minecraft.EnumHighlighting;
import binnie.craftgui.minecraft.INetworkedEntityGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.minecraft.WindowInventory;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerCraftGUI
extends Container
implements INetwork.CraftGUIAction {
    Window window;
    Map lastSentData = new HashMap();
    private Map syncedTanks = new HashMap();
    private PowerInfo syncedPower = new PowerInfo();
    private int errorType = 0;
    private ErrorState error = null;
    int mousedOverSlotNumber = -1;

    private Side getSide() {
        return this.window.isServer() ? Side.SERVER : Side.CLIENT;
    }

    public Slot func_75139_a(int par1) {
        if (par1 < 0 || par1 >= this.field_75151_b.size()) {
            return null;
        }
        return (Slot)this.field_75151_b.get(par1);
    }

    public void func_75141_a(int par1, ItemStack par2ItemStack) {
        if (this.func_75139_a(par1) != null) {
            this.func_75139_a(par1).func_75215_d(par2ItemStack);
        }
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        for (int i = 0; i < par1ArrayOfItemStack.length; ++i) {
            if (this.func_75139_a(i) == null) continue;
            this.func_75139_a(i).func_75215_d(par1ArrayOfItemStack[i]);
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        WindowInventory inventory = this.window.getWindowInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || (stack = new TransferRequest(stack, (IInventory)par1EntityPlayer.field_71071_by).transfer(true)) == null) continue;
            par1EntityPlayer.func_71021_b(stack);
        }
    }

    public ContainerCraftGUI(Window window) {
        this.window = window;
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public void newSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public final ItemStack func_82846_b(EntityPlayer player, int slotID) {
        return this.shiftClick(player, slotID);
    }

    private ItemStack shiftClick(EntityPlayer player, int slotnumber) {
        TransferRequest request = this.getShiftClickRequest(player, slotnumber);
        ItemStack itemstack = request.transfer(true);
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(slotnumber);
        shiftClickedSlot.func_75215_d(itemstack);
        shiftClickedSlot.func_75218_e();
        return null;
    }

    private TransferRequest getShiftClickRequest(EntityPlayer player, int slotnumber) {
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(slotnumber);
        ItemStack itemstack = null;
        if (shiftClickedSlot.func_75216_d()) {
            itemstack = shiftClickedSlot.func_75211_c().func_77946_l();
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        IInventory containerInventory = this.window.getInventory();
        WindowInventory windowInventory = this.window.getWindowInventory();
        int[] target = new int[36];
        for (int i = 0; i < 36; ++i) {
            target[i] = i;
        }
        if (shiftClickedSlot.field_75224_c == playerInventory) {
            return new TransferRequest(itemstack, containerInventory).setOrigin(shiftClickedSlot.field_75224_c);
        }
        return new TransferRequest(itemstack, (IInventory)playerInventory).setOrigin(shiftClickedSlot.field_75224_c).setTargetSlots(target);
    }

    public final ItemStack tankClick(EntityPlayer player, int slotID) {
        if (player.field_71071_by.func_70445_o() == null) {
            return null;
        }
        ItemStack heldItem = player.field_71071_by.func_70445_o().func_77946_l();
        heldItem = new TransferRequest(heldItem, this.window.getInventory()).setOrigin((IInventory)player.field_71071_by).setTargetSlots(new int[0]).setTargetTanks(new int[]{slotID}).transfer(true);
        player.field_71071_by.func_70437_b(heldItem);
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71113_k();
        }
        return heldItem;
    }

    public void func_75137_b(int i, int j) {
        super.func_75137_b(i, j);
        if (this.window.getInventory() instanceof INetworkedEntityGUI && this.window.isClient()) {
            ((INetworkedEntityGUI)this.window.getInventory()).recieveGUINetworkData(i, j);
        }
    }

    @Override
    public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        if (this.handleNBT(player, action)) {
            return;
        }
        this.window.recieveNBT(this.getSide(), player, action);
        INetwork.CraftGUIAction machine = (INetwork.CraftGUIAction)Machine.getInterface(INetwork.CraftGUIAction.class, this.window.getInventory());
        if (machine != null) {
            machine.recieveNBT(this.getSide(), player, action);
        }
    }

    private boolean handleNBT(EntityPlayer player, NBTTagCompound action) {
        if (this.getSide() == Side.SERVER && action.func_74740_e().equals("tank-click")) {
            this.tankClick(player, action.func_74771_c("id"));
        }
        if (action.func_74740_e().equals("tank-update")) {
            this.onTankUpdate(action);
        } else if (action.func_74740_e().equals("power-update")) {
            this.onPowerUpdate(action);
        } else if (action.func_74740_e().equals("error-update")) {
            this.onErrorUpdate(action);
        } else if (action.func_74740_e().equals("mouse-over-slot")) {
            this.onMouseOverSlot(player, action);
        } else if (action.func_74740_e().equals("shift-click-info")) {
            this.onRecieveShiftClickHighlights(player, action);
        }
        return false;
    }

    public void func_75142_b() {
        EntityPlayerMP player;
        super.func_75142_b();
        if (this.window.getInventory() instanceof INetworkedEntityGUI && this.window.isServer()) {
            LinkedHashMap data = new LinkedHashMap();
            ((INetworkedEntityGUI)this.window.getInventory()).addGUINetworkData(data);
            for (Map.Entry entry : data.entrySet()) {
                if (this.lastSentData.get(entry.getKey()) == entry.getValue()) continue;
                for (Object crafter : this.field_75149_d) {
                    ((ICrafting)crafter).func_71112_a((Container)this, ((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
                }
                this.lastSentData.put(entry.getKey(), entry.getValue());
            }
        }
        ITankMachine tanks = (ITankMachine)Machine.getInterface(ITankMachine.class, this.window.getInventory());
        IPoweredMachine powered = (IPoweredMachine)Machine.getInterface(IPoweredMachine.class, this.window.getInventory());
        IErrorStateSource error = (IErrorStateSource)Machine.getInterface(IErrorStateSource.class, this.window.getInventory());
        if (tanks != null && this.window.isServer()) {
            for (int i = 0; i < tanks.getTankInfos().length; ++i) {
                TankInfo tank = tanks.getTankInfos()[i];
                if (this.getTankInfo(i).equals(tank)) continue;
                for (int j = 0; j < this.field_75149_d.size(); ++j) {
                    if (!(this.field_75149_d.get(j) instanceof EntityPlayerMP)) continue;
                    EntityPlayerMP player2 = (EntityPlayerMP)this.field_75149_d.get(j);
                    BinnieCore.proxy.sendToPlayer(BinnieCore.instance, new PacketTankUpdate(i, tank), (EntityPlayer)player2);
                }
                this.syncedTanks.put(i, tank);
            }
        }
        if (powered != null && this.window.isServer() && !this.syncedPower.equals(powered.getPowerInfo())) {
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                if (!(this.field_75149_d.get(j) instanceof EntityPlayerMP)) continue;
                player = (EntityPlayerMP)this.field_75149_d.get(j);
                BinnieCore.proxy.sendToPlayer(BinnieCore.instance, new PacketPowerUpdate(powered.getPowerInfo()), (EntityPlayer)player);
            }
        }
        if (error != null && this.window.isServer()) {
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                if (!(this.field_75149_d.get(j) instanceof EntityPlayerMP)) continue;
                player = (EntityPlayerMP)this.field_75149_d.get(j);
                BinnieCore.proxy.sendToPlayer(BinnieCore.instance, new PacketErrorUpdate(error), (EntityPlayer)player);
            }
        }
    }

    public void onTankUpdate(NBTTagCompound nbt) {
        byte tankID = nbt.func_74771_c("tank");
        TankInfo tank = new TankInfo();
        tank.readFromNBT(nbt);
        this.syncedTanks.put(Integer.valueOf(tankID), tank);
    }

    public void onPowerUpdate(NBTTagCompound nbt) {
        this.syncedPower = new PowerInfo();
        this.syncedPower.readFromNBT(nbt);
    }

    public PowerInfo getPowerInfo() {
        return this.syncedPower;
    }

    public TankInfo getTankInfo(int tank) {
        return this.syncedTanks.containsKey(tank) ? (TankInfo)this.syncedTanks.get(tank) : new TankInfo();
    }

    public void onErrorUpdate(NBTTagCompound nbt) {
        this.errorType = nbt.func_74771_c("type");
        if (nbt.func_74764_b("name")) {
            this.error = new ErrorState("", "");
            this.error.readFromNBT(nbt);
        } else {
            this.error = null;
        }
    }

    public ErrorState getErrorState() {
        return this.error;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public CustomSlot[] getCustomSlots() {
        ArrayList<CustomSlot> slots = new ArrayList<CustomSlot>();
        for (Object object : this.field_75151_b) {
            if (!(object instanceof CustomSlot)) continue;
            slots.add((CustomSlot)((Object)object));
        }
        return slots.toArray(new CustomSlot[0]);
    }

    public void setMouseOverSlot(Slot slot) {
        if (slot.field_75222_d != this.mousedOverSlotNumber) {
            NBTTagCompound nbt = new NBTTagCompound("mouse-over-slot");
            nbt.func_74774_a("slot", (byte)slot.field_75222_d);
            BinnieCore.proxy.sendToServer(BinnieCore.instance, new PacketCraftGUI(nbt));
        }
    }

    private void onMouseOverSlot(EntityPlayer player, NBTTagCompound data) {
        byte slotnumber = data.func_74771_c("slot");
        TransferRequest request = this.getShiftClickRequest(player, slotnumber);
        request.transfer(false);
        NBTTagCompound nbt = new NBTTagCompound("shift-click-info");
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (TransferRequest.TransferSlot tslot : request.getInsertedSlots()) {
            CustomSlot slot = this.getSlot(tslot.inventory, tslot.id);
            if (slot == null) continue;
            slots.add(slot.field_75222_d);
        }
        int[] array = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            array[i] = (Integer)slots.get(i);
        }
        nbt.func_74783_a("slots", array);
        BinnieCore.proxy.sendToPlayer(BinnieCore.instance, new PacketCraftGUI(nbt), player);
    }

    private void onRecieveShiftClickHighlights(EntityPlayer player, NBTTagCompound data) {
        ((List)ControlSlot.highlighting.get((Object)EnumHighlighting.ShiftClick)).clear();
        for (int slotnumber : data.func_74759_k("slots")) {
            ((List)ControlSlot.highlighting.get((Object)EnumHighlighting.ShiftClick)).add(slotnumber);
        }
    }

    private CustomSlot getSlot(IInventory inventory, int id) {
        for (Object o : this.field_75151_b) {
            CustomSlot slot = (CustomSlot)((Object)o);
            if (slot.field_75224_c != inventory || slot.slotID != id) continue;
            return slot;
        }
        return null;
    }
}

