/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core;

import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.ITopLevelWidget;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.core.renderer.IRenderer;
import binnie.craftgui.core.renderer.IRendererWidget;
import binnie.craftgui.events.Event;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.resource.ITexture;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.lwjgl.opengl.GL11;

public abstract class Widget
implements IWidget {
    private IWidget parent = null;
    private List subWidgets = new ArrayList();
    private IPosition position = new Vector2f(0.0f, 0.0f);
    private IPosition size = new Vector2f(0.0f, 0.0f);
    private IPosition offset = new Vector2f(0.0f, 0.0f);
    IArea cropArea;
    IWidget cropWidget;
    boolean cropped = false;
    int colour = 0xFFFFFF;
    private boolean enabled = true;
    private boolean visible = true;

    public Widget(IWidget parent) {
        this.parent = parent;
        CraftGUI.registerWidgetClasses(this);
        if (parent != null) {
            parent.addWidget(this);
        }
    }

    @Override
    public final void deleteChild(IWidget child) {
        child.delete();
        this.subWidgets.remove(child);
    }

    @Override
    public final void deleteAllChildren() {
        while (!this.subWidgets.isEmpty()) {
            this.deleteChild((IWidget)this.subWidgets.get(0));
        }
    }

    @Override
    public final IWidget getParent() {
        return this.parent;
    }

    @Override
    public final ITopLevelWidget getSuperParent() {
        return this.isTopLevel() ? (ITopLevelWidget)((Object)this) : this.parent.getSuperParent();
    }

    @Override
    public final IWidget addWidget(IWidget widget) {
        this.subWidgets.add(widget);
        return widget;
    }

    @Override
    public final List getWidgets() {
        return this.subWidgets;
    }

    @Override
    public final boolean isTopLevel() {
        return this instanceof ITopLevelWidget;
    }

    @Override
    public final IPosition pos() {
        return this.position.add(this.offset);
    }

    @Override
    public final IPosition size() {
        return this.size;
    }

    @Override
    public final IPosition getPosition() {
        return this.pos();
    }

    @Override
    public final IArea getArea() {
        return new Area(Vector2f.ZERO, this.size());
    }

    @Override
    public final IPosition getOriginalPosition() {
        return this.position;
    }

    @Override
    public IArea getCroppedZone() {
        return this.cropArea;
    }

    @Override
    public void setCroppedZone(IWidget relative, IArea area) {
        this.cropArea = area;
        this.cropped = true;
        this.cropWidget = relative;
    }

    @Override
    public final IPosition getAbsolutePosition() {
        return this.isTopLevel() ? this.getPosition() : this.getParent().getAbsolutePosition().add(this.getPosition());
    }

    @Override
    public final IPosition getOriginalAbsolutePosition() {
        return this.isTopLevel() ? this.getOriginalPosition() : this.getParent().getOriginalPosition().sub(this.getOriginalPosition());
    }

    @Override
    public final IPosition getSize() {
        return this.size();
    }

    @Override
    public final IPosition getOffset() {
        return this.offset;
    }

    @Override
    public final void setPosition(IPosition vector) {
        if (!vector.equals(this.position)) {
            this.position = new Vector2f(vector);
            this.callEvent(new EventWidget.ChangePosition(this));
        }
    }

    @Override
    public final void setSize(IPosition vector) {
        if (!vector.equals(this.size)) {
            this.size = new Vector2f(vector);
            this.callEvent(new EventWidget.ChangeSize(this));
        }
    }

    @Override
    public final void setOffset(IPosition vector) {
        if (vector != this.offset) {
            this.offset = new Vector2f(vector);
            this.callEvent(new EventWidget.ChangeOffset(this));
        }
    }

    @Override
    public final void setColour(int colour) {
        if (this.colour != colour) {
            this.colour = colour;
            this.callEvent(new EventWidget.ChangeColour(this));
        }
    }

    @Override
    public final int getColour() {
        return this.colour;
    }

    @Override
    public boolean canMouseOver() {
        return false;
    }

    @Override
    public boolean canFocus() {
        return false;
    }

    @Override
    public final void callEvent(Event event) {
        this.getSuperParent().recieveEvent(event);
    }

    @Override
    public final void recieveEvent(Event event) {
        CraftGUI.handleEvent(this, event);
        for (IWidget child : this.getWidgets()) {
            child.recieveEvent(event);
        }
    }

    @Override
    public final IPosition getMousePosition() {
        return this.getSuperParent().getAbsoluteMousePosition();
    }

    @Override
    public final IPosition getRelativeMousePosition() {
        return this.isTopLevel() ? this.getMousePosition() : this.getParent().getRelativeMousePosition().sub(this.getPosition());
    }

    @Override
    public final Object getRenderer(Class renderer) {
        return this.getSuperParent().getTopLevelRenderer(renderer);
    }

    @Override
    public boolean isCroppedWidet() {
        return this.cropped;
    }

    private final void preRender() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.getPosition().x(), (float)this.getPosition().y(), (float)0.0f);
        ((IRendererWidget)this.getRenderer(IRendererWidget.class)).preRender(this);
    }

    private final void postRender() {
        ((IRendererWidget)this.getRenderer(IRendererWidget.class)).postRender(this);
        GL11.glPopMatrix();
    }

    @Override
    public final IWidget getCropWidget() {
        return this.cropWidget == null ? this : this.cropWidget;
    }

    @Override
    public final void renderBackground() {
        if (this.isVisible()) {
            this.preRender();
            this.onRenderBackground();
            for (IWidget widget : this.getWidgets()) {
                widget.renderBackground();
            }
            this.postRender();
        }
    }

    @Override
    public final void renderForeground() {
        if (this.isVisible()) {
            this.preRender();
            this.onRenderForeground();
            for (IWidget widget : this.getWidgets()) {
                widget.renderForeground();
            }
            this.postRender();
        }
    }

    @Override
    public final void renderOverlay() {
        if (this.isVisible()) {
            this.preRender();
            this.onRenderOverlay();
            for (IWidget widget : this.getWidgets()) {
                widget.renderOverlay();
            }
            this.postRender();
        }
    }

    @Override
    public final void update() {
        if (!this.isVisible()) {
            return;
        }
        if (this.getSuperParent() == this) {
            ((ITopLevelWidget)((Object)this)).updateTopLevel();
        }
        this.onUpdate();
        for (IWidget widget : this.getWidgets()) {
            widget.update();
        }
    }

    @Override
    public final IWidget calculateMousedOverWidget() {
        boolean amIMousedOver = this.calculateIsMouseOver();
        if (!this.isVisible()) {
            return null;
        }
        if (amIMousedOver || !this.isCroppedWidet()) {
            ListIterator li = this.getWidgets().listIterator(this.getWidgets().size());
            while (li.hasPrevious()) {
                IWidget child = (IWidget)li.previous();
                IWidget result = child.calculateMousedOverWidget();
                if (result == null) continue;
                return result;
            }
        }
        if (this.canMouseOver() && amIMousedOver) {
            return this;
        }
        return null;
    }

    @Override
    public final boolean calculateIsMouseOver() {
        IPosition mouse = this.getRelativeMousePosition();
        if (!this.cropped) {
            return this.isMouseOverWidget(mouse);
        }
        IWidget cropRelative = this.cropWidget != null ? this.cropWidget : this;
        IPosition pos = Vector2f.sub(cropRelative.getAbsolutePosition(), this.getAbsolutePosition());
        Vector2f size = new Vector2f(this.cropArea.size().x(), this.cropArea.size().y());
        return mouse.x() > pos.x() && mouse.y() > pos.y() && mouse.x() < pos.x() + size.x() && mouse.y() < pos.y() + size.y();
    }

    @Override
    public boolean isMouseOverWidget(IPosition relativeMouse) {
        return this.getArea().contains(relativeMouse);
    }

    @Override
    public final void enable() {
        this.enabled = true;
        this.callEvent(new EventWidget.Enable(this));
    }

    @Override
    public final void disable() {
        this.enabled = false;
        this.callEvent(new EventWidget.Disable(this));
    }

    @Override
    public final void show() {
        this.visible = true;
        this.callEvent(new EventWidget.Show(this));
    }

    @Override
    public final void hide() {
        this.visible = false;
        this.callEvent(new EventWidget.Hide(this));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && (this.isTopLevel() || this.getParent().isEnabled() && this.getParent().isChildEnabled(this));
    }

    @Override
    public final boolean isVisible() {
        return this.visible && (this.isTopLevel() || this.getParent().isVisible() && this.getParent().isChildVisible(this));
    }

    @Override
    public final boolean isFocused() {
        return this.getSuperParent().isFocused(this);
    }

    @Override
    public final boolean isDragged() {
        return this.getSuperParent().isDragged(this);
    }

    @Override
    public final boolean isMouseOver() {
        return this.getSuperParent().isMouseOver(this);
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return true;
    }

    @Override
    public boolean isChildEnabled(IWidget child) {
        return true;
    }

    @Override
    public void onRenderBackground() {
        ((IRendererWidget)this.getRenderer(IRendererWidget.class)).render(this, 0);
    }

    @Override
    public void onRenderForeground() {
        ((IRendererWidget)this.getRenderer(IRendererWidget.class)).render(this, 1);
    }

    @Override
    public void onRenderOverlay() {
        ((IRendererWidget)this.getRenderer(IRendererWidget.class)).render(this, 2);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public final void delete() {
        this.getSuperParent().widgetDeleted(this);
        this.onDelete();
    }

    @Override
    public void onDelete() {
    }

    @Override
    public Object getWidget(Class x) {
        for (IWidget child : this.getWidgets()) {
            if (x.isInstance(child)) {
                return child;
            }
            Object found = child.getWidget(x);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public abstract ITexture getTexture(Object var1);

    @Override
    public final boolean contains(IPosition position) {
        return this.getArea().contains(position);
    }

    public IRenderer getRenderer() {
        return (IRenderer)this.getRenderer(IRenderer.class);
    }
}

