/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.scroll;

import binnie.craftgui.controls.button.ControlButton;
import binnie.craftgui.controls.scroll.ControlScroll;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;

public class ControlScrollButton
extends ControlButton {
    Position pos;
    ControlScroll parent;
    int c = 0;

    public ControlScrollButton(ControlScroll parent, Position position) {
        super(parent, 0.0f, 0.0f, 0.0f, 0.0f, "");
        this.parent = parent;
        this.setSize(new Vector2f(parent.getSize().x(), parent.getSize().x()));
        this.pos = position;
        if (position == Position.Top) {
            this.setPosition(Vector2f.ZERO);
        } else {
            this.setPosition(new Vector2f(0.0f, (int)(parent.getSize().y() - parent.getSize().x())));
        }
    }

    @Override
    public void onMouseClick(EventMouse.Down event) {
        super.onMouseClick(event);
        this.pressButton();
    }

    public void pressButton() {
        float dir = 0.0f;
        dir = this.pos == Position.Top ? -1.0f : 1.0f;
        this.parent.getScrollableWidget().movePercentage(dir * 0.01f);
    }

    @Override
    public void onUpdate() {
        if (this.isDragged()) {
            ++this.c;
            if (this.c > 5) {
                this.c = 0;
                this.pressButton();
            }
        }
    }

    static enum Position {
        Top,
        Bottom;

    }
}

