/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.listbox;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.listbox.ControlList;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;

public class ControlOption
extends Control
implements IControlValue {
    Object value;

    @Override
    public void onUpdate() {
        if (this.getValue() == null) {
            return;
        }
        int colour = 0xA0A0A0;
        if (this.isCurrentSelection()) {
            colour = 0xFFFFFF;
        }
        this.setColour(colour);
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onMouseClick(EventMouse.Down event) {
        ((IControlValue)this.getParent()).setValue(this.getValue());
    }

    public ControlOption(ControlList controlList, Object option) {
        this(controlList, option, 16);
    }

    public ControlOption(ControlList controlList, Object option, int height) {
        super(controlList, 0.0f, height, controlList.getSize().x(), 20.0f);
        this.value = option;
        this.canMouseOver = this.value != null;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isCurrentSelection() {
        return this.getValue() != null && this.getValue().equals(((IControlValue)this.getParent()).getValue());
    }
}

