/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.proxy;

import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.IPacketProvider;
import binnie.core.network.packet.BinniePacket;
import binnie.core.network.packet.PacketUpdate;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.resource.BinnieResource;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class BinnieProxy
implements IBinnieProxy {
    short uniqueTextureUID = (short)1200;

    @Override
    public void bindTexture(BinnieResource texture) {
    }

    @Override
    public int getUniqueRenderID() {
        return RenderingRegistry.getNextAvailableRenderId();
    }

    @Override
    public void openGui(IBinnieMod mod, int id, EntityPlayer player, int x, int y, int z) {
        player.openGui((Object)mod, id, player.field_70170_p, x, y, z);
    }

    @Override
    public boolean isSimulating(World world) {
        return true;
    }

    @Override
    public void registerCustomItemRenderer(int itemID, IItemRenderer itemRenderer) {
    }

    @Override
    public void sendNetworkPacket(IPacketProvider mod, BinniePacket packet, int x, int y, int z) {
        if (packet == null) {
            return;
        }
        packet.setChannel(mod.getChannel());
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            for (int j = 0; j < worlds[i].field_73010_i.size(); ++j) {
                EntityPlayerMP player = (EntityPlayerMP)worlds[i].field_73010_i.get(j);
                if (!(Math.abs(player.field_70165_t - (double)x) <= 50.0) || !(Math.abs(player.field_70163_u - (double)y) <= 50.0) || !(Math.abs(player.field_70161_v - (double)z) <= 50.0)) continue;
                player.field_71135_a.func_72567_b(packet.getPacket());
            }
        }
    }

    @Override
    public void sendToPlayer(IPacketProvider mod, BinniePacket packet, EntityPlayer entityplayer) {
        packet.setChannel(mod.getChannel());
        EntityPlayerMP player = (EntityPlayerMP)entityplayer;
        player.field_71135_a.func_72567_b(packet.getPacket());
    }

    @Override
    public void sendToServer(IPacketProvider mod, BinniePacket packet) {
    }

    @Override
    public boolean needsTagCompoundSynched(Item item) {
        return item.func_77651_p();
    }

    @Override
    public World getWorld() {
        return null;
    }

    public void throwException(String message, Throwable e) {
        FMLCommonHandler.instance().raiseException(e, message, true);
    }

    public void addName(Object instance, String name) {
        LanguageRegistry.instance();
        LanguageRegistry.addName((Object)instance, (String)name);
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return null;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public File getDirectory() {
        return new File("./");
    }

    @Override
    public void preInit() {
    }

    @Override
    public void doInit() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void registerTileEntity(Class tile, String id, Object renderer) {
        GameRegistry.registerTileEntity((Class)tile, (String)id);
    }

    @Override
    public void createPipe(Item pipe) {
    }

    @Override
    public boolean isDebug() {
        return System.getenv().containsKey("BINNIE_DEBUG");
    }

    @Override
    public void registerBlockRenderer(Object renderer) {
    }

    @Override
    public Object createObject(String renderer) {
        return null;
    }

    @Override
    public void sendNetworkEntityPacket(INetworkedEntity entity) {
        PacketUpdate packet = new PacketUpdate(BinnieCorePacketID.NetworkEntityUpdate.ordinal(), entity);
        BinnieCore.proxy.sendNetworkPacket(BinnieCore.instance, packet, ((TileEntity)entity).field_70329_l, ((TileEntity)entity).field_70330_m, ((TileEntity)entity).field_70327_n);
    }

    @Override
    public Icon getIcon(IconRegister register, String mod, String name) {
        return null;
    }

    public void log(String string) {
        System.out.println("Binnie - " + string);
    }

    public LiquidStack registerLiquid(String name, int id, int meta) {
        return LiquidDictionary.getOrCreateLiquid((String)name, (LiquidStack)new LiquidStack(id, 1000, meta));
    }

    public void handleTextureRefresh(IconRegister register, int type) {
    }

    public void handlePostTextureRefresh(IconRegister register, int type) {
    }

    public short getUniqueTextureUID() {
        short s = this.uniqueTextureUID;
        this.uniqueTextureUID = (short)(s + 1);
        return s;
    }
}

