/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network.packet;

import binnie.core.network.packet.IPacketLocation;
import binnie.core.network.packet.PacketNBT;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTileNBT
extends PacketNBT
implements IPacketLocation {
    private int posX;
    private int posY;
    private int posZ;
    NBTTagCompound nbttagcompound;

    public PacketTileNBT(int id, TileEntity tile) {
        super(id);
        this.posX = tile.field_70329_l;
        this.posY = tile.field_70330_m;
        this.posZ = tile.field_70327_n;
        this.nbttagcompound = new NBTTagCompound();
        tile.func_70310_b(this.nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        super.writeData(data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        super.readData(data);
    }

    @Override
    public TileEntity getTarget(World world) {
        return world.func_72796_p(this.posX, this.posY, this.posZ);
    }

    @Override
    public int getX() {
        return this.posX;
    }

    @Override
    public int getY() {
        return this.posY;
    }

    @Override
    public int getZ() {
        return this.posZ;
    }

    @Override
    public NBTTagCompound getTagCompound() {
        return this.nbttagcompound;
    }

    @Override
    void setTagCompound(NBTTagCompound nbt) {
        this.nbttagcompound = nbt;
    }
}

