/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network;

import binnie.core.BinnieException;
import binnie.core.IBinnieMod;
import binnie.core.network.IPacketID;
import binnie.core.network.IPacketProvider;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;

public final class BinniePacketHandler
implements IPacketHandler {
    IPacketProvider provider;

    public BinniePacketHandler(IBinnieMod mod) {
        this.setProvider(mod);
    }

    public void setProvider(IPacketProvider provider) {
        this.provider = provider;
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        if (this.provider == null) {
            throw new BinnieException("A BinniePacketHandler has no IPacketProvider associated with it.");
        }
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte packetId = data.readByte();
            for (IPacketID id : this.provider.getPacketIDs()) {
                if (id.ordinal() != packetId) continue;
                id.onPacketData(manager, packet, player, data);
                data.close();
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

