/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IBuildcraft;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.triggers.TriggerPower;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class ComponentPowerReceptor
extends MachineComponent
implements IPoweredMachine,
IBuildcraft.TriggerProvider {
    int currentEnergy;
    int maxStorage;
    float previousPower = 0.0f;
    LinkedList inputs = new LinkedList();
    static final int inputAverageTicks = 20;
    private IPowerProvider powerProvider = null;
    int[] config;

    public ComponentPowerReceptor(IMachine machine) {
        this(machine, 1000);
    }

    public ComponentPowerReceptor(IMachine machine, int storage) {
        super(machine);
        this.setPowerProvider(PowerFramework.currentFramework.createPowerProvider());
        this.setConfig(10, 5, 40, 20, storage);
        this.getPowerProvider().configurePowerPerdition(0, 100);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("powerProvider") && this.getPowerProvider() != null) {
            this.getPowerProvider().readFromNBT(nbttagcompound.func_74775_l("powerProvider"));
            this.getPowerProvider().configure(this.config[0], this.config[1], this.config[2], this.config[3], this.config[4]);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.getPowerProvider() != null) {
            NBTTagCompound powerNBT = new NBTTagCompound();
            this.getPowerProvider().writeToNBT(powerNBT);
            nbttagcompound.func_74766_a("powerProvider", powerNBT);
        }
    }

    @Override
    public final void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public final IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public final void doWork() {
    }

    @Override
    public final int powerRequest(ForgeDirection from) {
        float space = (float)this.powerProvider.getMaxEnergyStored() - this.powerProvider.getEnergyStored();
        if (space < (float)this.powerProvider.getMaxEnergyReceived() && space > (float)this.powerProvider.getMinEnergyReceived()) {
            return (int)space;
        }
        return this.powerProvider.getMaxEnergyReceived();
    }

    @Override
    public void onUpdate() {
        this.currentEnergy = (int)this.getPowerProvider().getEnergyStored();
        this.maxStorage = this.getPowerProvider().getMaxEnergyStored();
        this.getPowerProvider().update((IPowerReceptor)this.getMachine().getTileEntity());
    }

    @Override
    public PowerInfo getPowerInfo() {
        return new PowerInfo(this, 0.0f);
    }

    @Override
    public final void getTriggers(List triggers) {
        triggers.add(TriggerPower.powerNone(this));
        triggers.add(TriggerPower.powerLow(this));
        triggers.add(TriggerPower.powerMedium(this));
        triggers.add(TriggerPower.powerHigh(this));
        triggers.add(TriggerPower.powerFull(this));
    }

    @Override
    public void setConfig(int latency, int minEnergy, int maxEnergy, int activeEnergy, int storage) {
        this.config = new int[]{latency, minEnergy, maxEnergy, activeEnergy, storage};
        this.getPowerProvider().configure(latency, minEnergy, maxEnergy, activeEnergy, storage);
    }
}

