/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.TankInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class ComponentTankContainer
extends MachineComponent
implements ITankMachine {
    Map tanks = new LinkedHashMap();

    public ComponentTankContainer(IMachine machine) {
        super(machine);
    }

    @Override
    public final void addTank(int index, String name, int capacity) {
        this.tanks.put(index, new TankSlot(index, name, capacity));
    }

    public final int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int index = this.getTankIndexToFill(from, resource);
        if (this.tanks.containsKey(index)) {
            return this.fill(index, resource, doFill);
        }
        return 0;
    }

    public final LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int index = this.getTankIndexToDrain(from);
        if (this.tanks.containsKey(index)) {
            return this.drain(index, maxDrain, doDrain);
        }
        return null;
    }

    public final int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (!this.tanks.containsKey(tankIndex)) {
            return 0;
        }
        if (!this.isLiquidValidForTank(resource, tankIndex)) {
            return 0;
        }
        TankSlot tank = (TankSlot)this.tanks.get(tankIndex);
        return tank.getTank().fill(resource, doFill);
    }

    public final LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (!this.tanks.containsKey(tankIndex)) {
            return null;
        }
        TankSlot tank = (TankSlot)this.tanks.get(tankIndex);
        return tank.getTank().drain(maxDrain, doDrain);
    }

    public final ILiquidTank[] getTanks(ForgeDirection direction) {
        return this.getTanks();
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.getTanks(direction).length > 0 ? this.getTanks(direction)[0] : null;
    }

    public int getTankIndexToFill(ForgeDirection from, LiquidStack resource) {
        return 0;
    }

    public int getTankIndexToDrain(ForgeDirection from) {
        return 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("liquidTanks")) {
            NBTTagList tanksNBT = nbttagcompound.func_74761_m("liquidTanks");
            for (int i = 0; i < tanksNBT.func_74745_c(); ++i) {
                NBTTagCompound tankNBT = (NBTTagCompound)tanksNBT.func_74743_b(i);
                int index = tankNBT.func_74762_e("index");
                if (!this.tanks.containsKey(index)) continue;
                ((TankSlot)this.tanks.get(index)).readFromNBT(tankNBT);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList tanksNBT = new NBTTagList();
        for (Map.Entry entry : this.tanks.entrySet()) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            tankNBT.func_74768_a("index", ((Integer)entry.getKey()).intValue());
            ((TankSlot)entry.getValue()).writeToNBT(tankNBT);
            tanksNBT.func_74742_a((NBTBase)tankNBT);
        }
        nbttagcompound.func_74782_a("liquidTanks", (NBTBase)tanksNBT);
    }

    @Override
    public boolean isTankReadOnly(int tank) {
        return ((TankSlot)this.tanks.get(tank)).isReadOnly();
    }

    @Override
    public boolean isLiquidValidForTank(LiquidStack liquid, int tank) {
        return ((TankSlot)this.tanks.get(tank)).isValid(liquid);
    }

    @Override
    public TankInfo[] getTankInfos() {
        return TankInfo.get(this);
    }

    @Override
    public ILiquidTank getTank(int index) {
        return this.getTanks()[index];
    }

    @Override
    public ILiquidTank[] getTanks() {
        ArrayList<ILiquidTank> ltanks = new ArrayList<ILiquidTank>();
        for (TankSlot tank : this.tanks.values()) {
            ltanks.add(tank.getTank());
        }
        return ltanks.toArray(new ILiquidTank[0]);
    }

    @Override
    public TankSlot getTankSlot(int index) {
        return (TankSlot)this.tanks.get(index);
    }
}

