/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.machines.IMachine;
import binnie.core.machines.power.ITankMachine;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class MachineUtil {
    IMachine machine;

    public MachineUtil(IMachine machine) {
        this.machine = machine;
    }

    private IInventory getInventory() {
        return (IInventory)this.machine.getInterface(IInventory.class);
    }

    private ITankMachine getTankContainer() {
        return (ITankMachine)this.machine.getInterface(ITankMachine.class);
    }

    public boolean isSlotEmpty(int slot) {
        return this.getInventory().func_70301_a(slot) == null;
    }

    public ILiquidTank getTank(int id) {
        return this.getTankContainer().getTanks(ForgeDirection.UNKNOWN)[id];
    }

    public boolean spaceInTank(int id, int amount) {
        ILiquidTank tank = this.getTank(id);
        int space = tank.getCapacity() - (tank.getLiquid() == null ? 0 : tank.getLiquid().amount);
        return amount < space;
    }

    public ItemStack getStack(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public void deleteStack(int slot) {
        this.setStack(slot, null);
    }

    public ItemStack decreaseStack(int slotWood, int amount) {
        return this.getInventory().func_70298_a(slotWood, amount);
    }

    public void setStack(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public void fillTank(int id, LiquidStack liquidStack) {
        ILiquidTank tank = this.getTank(id);
        tank.fill(liquidStack, true);
    }

    public void addStack(int slot, ItemStack addition) {
        if (this.isSlotEmpty(slot)) {
            this.setStack(slot, addition);
        } else {
            ItemStack merge = this.getStack(slot);
            if (merge.func_77969_a(addition) && merge.field_77994_a + addition.field_77994_a <= merge.func_77976_d()) {
                merge.field_77994_a += addition.field_77994_a;
                this.setStack(slot, merge);
            }
        }
    }

    public void drainTank(int tank, int amount) {
        this.getTank(tank).drain(amount, true);
    }

    public boolean liquidInTank(int tank, int amount) {
        return this.getTank(tank).drain(amount, false) != null && this.getTank((int)tank).drain((int)amount, (boolean)false).amount == amount;
    }

    public void damageItem(int slot, int damage) {
        ItemStack item = this.getStack(slot);
        if (damage < 0) {
            item.func_77964_b(Math.max(0, item.func_77960_j() + damage));
        } else if (item.func_96631_a(damage, new Random())) {
            this.setStack(slot, null);
        }
        this.setStack(slot, item);
    }
}

