/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.machines.BlockMachine;
import binnie.core.machines.IMachineType;
import binnie.core.machines.ItemMachine;
import binnie.core.machines.MachineManager;
import binnie.core.machines.MachinePackage;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public class MachineGroup {
    int blockID;
    String blockName;
    String name;
    Map packages = new LinkedHashMap();
    Map packagesID = new LinkedHashMap();
    BlockMachine block;
    boolean renderedTileEntity = true;

    public MachineGroup(String name, int blockID, String blockName, IMachineType[] types) {
        this.name = name;
        this.blockID = blockID;
        this.blockName = blockName;
        for (IMachineType type : types) {
            try {
                MachinePackage pack = (MachinePackage)type.getPackageClass().newInstance();
                pack.assignMetadata(type.ordinal());
                pack.setActive(type.isActive());
                this.addPackage(pack);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        MachineManager.registerMachineGroup(this);
    }

    private void addPackage(MachinePackage pack) {
        this.packages.put(pack.getUID(), pack);
        this.packagesID.put(pack.getMetadata(), pack);
        pack.setGroup(this);
    }

    public Collection getPackages() {
        return this.packages.values();
    }

    public BlockMachine getBlock() {
        return this.block;
    }

    public MachinePackage getPackage(int metadata) {
        return (MachinePackage)this.packagesID.get(metadata);
    }

    public MachinePackage getPackage(String name) {
        return (MachinePackage)this.packages.get(name);
    }

    public final void init() {
        this.block = new BlockMachine(this.blockID, this, this.blockName);
    }

    public void register() {
        if (this.block != null) {
            GameRegistry.registerBlock((Block)this.block, ItemMachine.class, (String)this.blockName);
            for (MachinePackage pack : this.getPackages()) {
                pack.register();
            }
        }
    }

    public String getUID() {
        return this.name;
    }

    boolean isTileEntityRenderered() {
        return this.renderedTileEntity;
    }

    public void renderAsBlock() {
        this.renderedTileEntity = false;
    }

    public void setCreativeTab(CreativeTabs tab) {
        this.block.func_71849_a(tab);
    }
}

