/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.network.INetwork;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.PacketPayload;
import binnie.craftgui.minecraft.INetworkedEntityGUI;
import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.INBTTagable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.liquids.ITankContainer;

public class Machine
implements INetworkedEntity,
INBTTagable,
INetworkedEntityGUI,
INetwork.CraftGUIAction,
IMachine {
    MachinePackage machinePackage;
    Map componentInterfaceMap = new LinkedHashMap();
    Map componentMap = new LinkedHashMap();
    TileEntity tile;
    int nextProgressBarID = 0;

    public Machine(MachinePackage pack, TileEntity tile) {
        pack.createMachine(this);
        this.machinePackage = pack;
        this.tile = tile;
    }

    @Override
    public void addComponent(MachineComponent component) {
        if (component == null) {
            throw new NullPointerException("Can't have a null machine component!");
        }
        component.setMachine(this);
        this.componentMap.put(component.getClass(), component);
        for (Class inter : component.getComponentInterfaces()) {
            if (!this.componentInterfaceMap.containsKey(inter)) {
                this.componentInterfaceMap.put(inter, new ArrayList());
            }
            ((List)this.componentInterfaceMap.get(inter)).add(component);
        }
    }

    public Collection getComponents() {
        return this.componentMap.values();
    }

    public MachineComponent getComponent(Class componentClass) {
        return this.hasComponent(componentClass) ? (MachineComponent)componentClass.cast(this.componentMap.get(componentClass)) : null;
    }

    @Override
    public Object getInterface(Class interfaceClass) {
        if (this.hasInterface(interfaceClass)) {
            return this.getInterfaces(interfaceClass).get(0);
        }
        if (interfaceClass.isInstance(this.getPackage())) {
            return interfaceClass.cast(this.getPackage());
        }
        for (MachineComponent component : this.getComponents()) {
            if (!interfaceClass.isInstance(component)) continue;
            return interfaceClass.cast(component);
        }
        return null;
    }

    public List getInterfaces(Class interfaceClass) {
        ArrayList interfaces = new ArrayList();
        if (!this.hasInterface(interfaceClass)) {
            return interfaces;
        }
        for (MachineComponent component : (List)this.componentInterfaceMap.get(interfaceClass)) {
            interfaces.add(interfaceClass.cast(component));
        }
        return interfaces;
    }

    public boolean hasInterface(Class interfaceClass) {
        return this.componentInterfaceMap.containsKey(interfaceClass);
    }

    public boolean hasComponent(Class componentClass) {
        return this.componentMap.containsKey(componentClass);
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tile;
    }

    public void sendPacket() {
        if (!BinnieCore.proxy.isSimulating(this.getTileEntity().func_70314_l())) {
            return;
        }
        BinnieCore.proxy.sendNetworkEntityPacket((INetworkedEntity)this.getTileEntity());
    }

    public Side getSide() {
        return BinnieCore.proxy.isSimulating(this.getTileEntity().field_70331_k) ? Side.SERVER : Side.CLIENT;
    }

    @Override
    public void writeToPacket(PacketPayload payload) {
        for (MachineComponent component : this.getComponents()) {
            if (!(component instanceof INetworkedEntity)) continue;
            ((INetworkedEntity)((Object)component)).writeToPacket(payload);
        }
    }

    @Override
    public void readFromPacket(PacketPayload payload) {
        for (MachineComponent component : this.getComponents()) {
            if (!(component instanceof INetworkedEntity)) continue;
            ((INetworkedEntity)((Object)component)).readFromPacket(payload);
        }
    }

    public void onRightClick(World world, EntityPlayer player, int x, int y, int z) {
        for (IInteraction.RightClick component : this.getInterfaces(IInteraction.RightClick.class)) {
            component.onRightClick(world, player, x, y, z);
        }
    }

    @Override
    public void onInventoryUpdate() {
        for (MachineComponent component : this.getComponents()) {
            if (!(component instanceof IInventory)) continue;
            component.onInventoryUpdate();
        }
        for (MachineComponent component : this.getComponents()) {
            if (component instanceof IInventory) continue;
            component.onInventoryUpdate();
        }
    }

    public void onUpdate() {
        if (BinnieCore.proxy.isSimulating(this.getWorld())) {
            for (MachineComponent component : this.getComponents()) {
                component.onUpdate();
            }
        }
    }

    public IInventory getInventory() {
        return (IInventory)this.getInterface(IInventory.class);
    }

    public ITankContainer getTankContainer() {
        return (ITankContainer)this.getInterface(ITankContainer.class);
    }

    public IPowerReceptor getPowerReceptor() {
        return (IPowerReceptor)this.getInterface(IPowerReceptor.class);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        for (MachineComponent component : this.getComponents()) {
            component.readFromNBT(nbttagcompound);
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        for (MachineComponent component : this.getComponents()) {
            component.writeToNBT(nbttagcompound);
        }
    }

    public MachinePackage getPackage() {
        return this.machinePackage;
    }

    @Override
    public void addGUINetworkData(Map data) {
        for (INetwork.GUI component : this.getInterfaces(INetwork.GUI.class)) {
            component.addGUINetworkData(data);
        }
    }

    @Override
    public void recieveGUINetworkData(int id, int data) {
        for (INetwork.GUI component : this.getInterfaces(INetwork.GUI.class)) {
            component.recieveGUINetworkData(id, data);
        }
    }

    public static IMachine getMachine(Object inventory) {
        if (inventory != null && inventory instanceof IMachine) {
            return (IMachine)inventory;
        }
        if (inventory != null && inventory instanceof TileEntityMachine) {
            return ((TileEntityMachine)inventory).getMachine();
        }
        if (inventory != null && inventory instanceof MachineComponent) {
            return ((MachineComponent)inventory).getMachine();
        }
        return null;
    }

    public static Object getInterface(Class interfac, Object inventory) {
        IMachine machine = Machine.getMachine(inventory);
        if (machine != null) {
            return machine.getInterface(interfac);
        }
        if (interfac.isInstance(inventory)) {
            return interfac.cast(inventory);
        }
        return null;
    }

    @Override
    public MachineUtil getMachineUtil() {
        return new MachineUtil(this);
    }

    @Override
    public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        for (INetwork.CraftGUIAction component : this.getInterfaces(INetwork.CraftGUIAction.class)) {
            component.recieveNBT(side, player, action);
        }
    }

    @Override
    public World getWorld() {
        return this.getTileEntity().func_70314_l();
    }

    public void onBlockDestroy() {
        for (MachineComponent component : this.getComponents()) {
            component.onDestruction();
        }
    }

    @Override
    public int getUniqueProgressBarID() {
        return this.nextProgressBarID++;
    }
}

