/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.MachineManager;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachine
extends BlockContainer {
    MachineGroup group;

    public BlockMachine(int id, MachineGroup group, String blockName) {
        super(id, Material.field_76243_f);
        this.group = group;
        this.func_71848_c(1.5f);
        this.func_71864_b(blockName);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (MachinePackage pack : this.group.getPackages()) {
            if (!pack.isActive()) continue;
            itemList.add(new ItemStack((Block)this, 1, pack.getMetadata().intValue()));
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return MachineManager.getMachineRenderID();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.group.getPackage(metadata) == null) {
            return null;
        }
        return this.group.getPackage(metadata).createTileEntity();
    }

    public String getMachineName(int meta) {
        if (this.group.getPackage(meta) == null) {
            return "Unnamed Machine";
        }
        return this.group.getPackage(meta).getDisplayName();
    }

    public int func_71899_b(int par1) {
        return par1;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileEntityMachine();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!BinnieCore.proxy.isSimulating(world)) {
            return true;
        }
        if (player.func_70093_af()) {
            return true;
        }
        TileEntity entity = world.func_72796_p(x, y, z);
        if (entity instanceof TileEntityMachine) {
            ((TileEntityMachine)entity).getMachine().onRightClick(world, player, x, y, z);
        }
        return true;
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLiving entityliving, ItemStack stack) {
        if (!BinnieCore.proxy.isSimulating(world)) {
            return;
        }
        TileEntityMachine tile = (TileEntityMachine)world.func_72796_p(i, j, k);
        if (entityliving instanceof EntityPlayer) {
            tile.setUsername(((EntityPlayer)entityliving).field_71092_bJ);
        }
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity entity = world.func_72796_p(x, y, z);
        if (entity instanceof TileEntityMachine && ((TileEntityMachine)entity).getMachine().hasInterface(IMachineTexturedFaces.class)) {
            return ((IMachineTexturedFaces)((TileEntityMachine)entity).getMachine().getInterface(IMachineTexturedFaces.class)).getIcon(side);
        }
        return null;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity tileentity = world.func_72796_p(x, y, z);
        if (!(tileentity instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine entity = (TileEntityMachine)tileentity;
        if (entity != null) {
            entity.onBlockDestroy();
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public static interface IMachineTexturedFaces {
        public Icon getIcon(int var1);
    }
}

