/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.BinnieCore;
import binnie.core.liquid.ILiquidType;
import binnie.core.liquid.ItemLiquid;
import binnie.core.liquid.ItemLiquidContainer;
import forestry.api.core.ItemInterface;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public enum LiquidContainer {
    CAPSULE("Capsule"),
    REFRACTORY("Capsule"),
    CAN("Can"),
    BUCKET("Bucket"),
    GLASS("Bottle");

    Icon bottle;
    Icon contents;
    String name;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private LiquidContainer() {
        void name;
        this.name = name;
    }

    public void updateIcons(IconRegister register) {
        this.bottle = BinnieCore.proxy.getIcon(register, "forestry", "liquids/" + this.toString().toLowerCase() + ".bottle");
        this.contents = BinnieCore.proxy.getIcon(register, "forestry", "liquids/" + this.toString().toLowerCase() + ".contents");
    }

    public static LiquidContainer getContainer(int container) {
        return container >= LiquidContainer.values().length ? CAPSULE : LiquidContainer.values()[container];
    }

    public String getName() {
        return this.name;
    }

    public void register(ItemLiquid itemLiquid, ItemLiquidContainer itemContainer, ILiquidType liquid) {
        ItemStack empty = null;
        switch (this) {
            case BUCKET: {
                empty = new ItemStack(Item.field_77788_aw, 1, 0);
                break;
            }
            case CAN: {
                empty = ItemInterface.getItem((String)"canEmpty");
                break;
            }
            case CAPSULE: {
                empty = ItemInterface.getItem((String)"waxCapsule");
                break;
            }
            case GLASS: {
                empty = new ItemStack(Item.field_77729_bt, 1, 0);
                break;
            }
            case REFRACTORY: {
                empty = ItemInterface.getItem((String)"refractoryEmpty");
            }
        }
        LiquidContainerData data = new LiquidContainerData(new LiquidStack(itemLiquid.field_77779_bT, 1000, liquid.ordinal()), new ItemStack(itemContainer.field_77779_bT, 1, liquid.ordinal() + this.ordinal() * 16), empty);
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)data);
    }
}

