/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.genetics.BinnieGenetics;
import binnie.core.genetics.BreedingSystem;
import binnie.core.resource.ResourceManager;
import binnie.extratrees.ExtraTrees;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.ILepidopteristTracker;
import net.minecraft.entity.player.EntityPlayer;

public class MothBreedingSystem
extends BreedingSystem {
    public MothBreedingSystem() {
        this.iconUndiscovered = ResourceManager.getItemIcon(ExtraTrees.instance, "icon/undiscoveredMoth");
        this.iconDiscovered = ResourceManager.getItemIcon(ExtraTrees.instance, "icon/discoveredMoth");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        return 0.0f;
    }

    @Override
    public String getDescriptor() {
        return "Lepidopterist";
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return BinnieGenetics.getButterflyRoot();
    }

    @Override
    public String getChromosomeName(int i) {
        EnumButterflyChromosome chromo = (EnumButterflyChromosome)this.getChromosome(i);
        switch (chromo) {
            case EFFECT: {
                return "Effect";
            }
            case FERTILITY: {
                return "Fertility";
            }
            case FIRE_RESIST: {
                return "Fire Resistance";
            }
            case FLOWER_PROVIDER: {
                return "Flowers";
            }
            case HUMIDITY_TOLERANCE: {
                return "Humidity Tolerance";
            }
            case LIFESPAN: {
                return "Lifespan";
            }
            case METABOLISM: {
                return "Metabolism";
            }
            case NOCTURNAL: {
                return "Nocturnal";
            }
            case SIZE: {
                return "Size";
            }
            case SPECIES: {
                return "Species";
            }
            case SPEED: {
                return "Production";
            }
            case TEMPERATURE_TOLERANCE: {
                return "Temperature Tolerance";
            }
            case TOLERANT_FLYER: {
                return "Rain Tolerance";
            }
        }
        return "";
    }

    @Override
    public String getEpitome(float discoveredPercentage) {
        if (discoveredPercentage == 1.0f) {
            return "Monarch of the Butterflies";
        }
        if (discoveredPercentage < 0.1f) {
            return "Bug Catcher";
        }
        if (discoveredPercentage < 0.3f) {
            return "Moth Chaser";
        }
        if (discoveredPercentage < 0.5f) {
            return "Scoop Wizard";
        }
        if (discoveredPercentage < 0.7f) {
            return "Caterpiller Lord";
        }
        if (discoveredPercentage < 0.9f) {
            return "Winged Assassin";
        }
        if (discoveredPercentage < 1.0f) {
            return "Moth King";
        }
        return "";
    }

    @Override
    public int getColour() {
        return 62194;
    }

    @Override
    public Class getTrackerClass() {
        return ILepidopteristTracker.class;
    }
}

