/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.core.gui;

import bluedart.proxy.Proxies;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;
import thermalexpansion.core.utils.SessionVars;

public abstract class Tab {
    protected static FontRenderer tabFontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
    private boolean open;
    protected Gui myGui;
    protected boolean leftSide;
    protected int overlayColor = 0xFFFFFF;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    protected int limitWidth = 128;
    protected int maxWidth = 124;
    protected int minWidth;
    protected int currentWidth = this.minWidth = 22;
    protected int maxHeight = 22;
    protected int minHeight;
    protected int currentHeight = this.minHeight = 22;

    public Tab(Gui gui) {
        this.myGui = gui;
    }

    public abstract void draw(int var1, int var2);

    protected void drawBackground(int x, int y) {
        float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        if (this.leftSide) {
            Proxies.common.bindTexture("/thermalexpansion/gfx/gui/tab_left.png");
            this.myGui.func_73729_b(x - this.currentWidth, y + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
            this.myGui.func_73729_b(x - this.currentWidth + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.myGui.func_73729_b(x - this.currentWidth, y, 0, 0, 4, 4);
            this.myGui.func_73729_b(x - this.currentWidth + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        } else {
            Proxies.common.bindTexture("/thermalexpansion/gfx/gui/tab_right.png");
            this.myGui.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            this.myGui.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.myGui.func_73729_b(x, y, 0, 0, 4, 4);
            this.myGui.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawIcon(String texture, int iconIndex, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.common.bindTexture(texture);
        int textureRow = iconIndex >> 4;
        int textureColumn = iconIndex - 16 * textureRow;
        this.myGui.func_73729_b(x, y, 16 * textureColumn, 16 * textureRow, 16, 16);
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public abstract String getTooltip();

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.leftSide ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight : mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight;
    }

    protected boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isVisible() {
        return true;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.leftSide) {
                SessionVars.setOpenedLeftTab(null);
            } else {
                SessionVars.setOpenedRightTab(null);
            }
        } else {
            this.open = true;
            if (this.leftSide) {
                SessionVars.setOpenedLeftTab(this.getClass());
            } else {
                SessionVars.setOpenedRightTab(this.getClass());
            }
        }
    }

    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += 8;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= 8;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += 8;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= 8;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
    }
}

