/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.core.gui;

import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thermalexpansion.core.gui.Tab;
import thermalexpansion.core.utils.SessionVars;

public abstract class GuiTE
extends GuiContainer {
    protected static int SCALE_ENERGY = 42;
    protected static int SCALE_LIQUID = 60;
    protected static int SCALE_PROGRESS = 24;
    protected static int SCALE_SPEED = 16;
    protected ArrayList tabListLeft = new ArrayList();
    protected ArrayList tabListRight = new ArrayList();
    protected int mouseX = 0;
    protected int mouseY = 0;
    public static boolean enableGuiBorders;
    public static boolean enableInfoTabs;
    public static boolean enableTutorialTabs;

    public GuiTE(Container container) {
        super(container);
    }

    protected void func_74189_g(int i, int j) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawTabs(this.mouseX, this.mouseY);
        this.drawTooltips();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected abstract void drawTooltips();

    protected void drawColoredSlot(int x, int y, SlotColor color, SlotType type, SlotRender render) {
        if (enableGuiBorders) {
            this.drawColoredSlotWithBorder(x, y, color, type, render);
        } else {
            this.drawColoredSlotNoBorder(x, y, color, type, render);
        }
    }

    protected void drawColoredSlotNoBorder(int x, int y, SlotColor color, SlotType type, SlotRender render) {
        int sizeX = 0;
        int sizeY = 0;
        int offsetX = color.ordinal() / 3 * 128;
        int offsetY = color.ordinal() % 3 * 32;
        switch (type) {
            case SINGLE: {
                sizeX = 16;
                sizeY = 16;
                offsetX += 8;
                offsetY += 8;
                break;
            }
            case OUTPUT: {
                sizeX = 24;
                sizeY = 24;
                offsetX += 36;
                offsetY += 4;
                break;
            }
            case DOUBLEOUTPUT: {
                sizeX = 42;
                sizeY = 24;
                offsetX += 75;
                offsetY += 4;
            }
        }
        switch (render) {
            case TOP: {
                sizeY /= 2;
                break;
            }
            case BOTTOM: {
                y += (sizeY /= 2);
                offsetY += sizeY;
                break;
            }
        }
        this.func_73729_b(x, y, offsetX, offsetY, sizeX, sizeY);
    }

    protected void drawColoredSlotWithBorder(int x, int y, SlotColor color, SlotType type, SlotRender render) {
        int sizeX = 32;
        int sizeY = 32;
        int offsetX = color.ordinal() / 3 * 128;
        int offsetY = color.ordinal() % 3 * 32;
        offsetX += type.ordinal() * 32;
        if (type.ordinal() == 2) {
            sizeX = 64;
        }
        switch (type) {
            case SINGLE: {
                x -= 8;
                y -= 8;
                break;
            }
            case OUTPUT: {
                x -= 4;
                y -= 4;
                break;
            }
            case DOUBLEOUTPUT: {
                x -= 11;
                y -= 4;
            }
        }
        switch (render) {
            case TOP: {
                sizeY /= 2;
                break;
            }
            case BOTTOM: {
                y += (sizeY /= 2);
                offsetY += sizeY;
                break;
            }
        }
        this.func_73729_b(x, y, offsetX, offsetY, sizeX, sizeY);
    }

    protected void drawColoredLiquidSlot(int x, int y, SlotColor color) {
        if (enableGuiBorders) {
            this.drawColoredLiquidSlotWithBorder(x, y, color);
        } else {
            this.drawColoredLiquidSlotNoBorder(x, y, color);
        }
    }

    protected void drawColoredLiquidSlotNoBorder(int x, int y, SlotColor color) {
        int sizeX = 16;
        int sizeY = 60;
        int offsetX = color.ordinal() * 32;
        int offsetY = 96;
        this.func_73729_b(x, y, offsetX + 8, offsetY + 2, sizeX, sizeY);
    }

    protected void drawColoredLiquidSlotWithBorder(int x, int y, SlotColor color) {
        int sizeX = 32;
        int sizeY = 64;
        int offsetX = color.ordinal() * 32;
        int offsetY = 96;
        this.func_73729_b(x - 8, y - 2, offsetX, offsetY, sizeX, sizeY);
    }

    protected void drawLiquid(int j, int k, int liquidId, int liquidMeta, int width, int height) {
        int liquidImgIndex = 0;
        try {
            LiquidStack tempStack = new LiquidStack(liquidId, 0, liquidMeta);
            if (tempStack.canonical() == null) {
                System.out.println("Abort.");
                return;
            }
            this.field_73882_e.field_71446_o.func_98187_b(tempStack.canonical().getTextureSheet());
        }
        catch (Exception e) {
            System.out.println("Nope.");
            return;
        }
        int imgLine = liquidImgIndex / 16;
        int imgColumn = liquidImgIndex - imgLine * 16;
        int x = 0;
        int y = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (x = 0; x < width; x += 16) {
            for (y = 0; y < height; y += 16) {
                drawWidth = Math.min(width - x, 16);
                drawHeight = Math.min(height - y, 16);
                this.func_73729_b(j + x, k + y, imgColumn * 16, imgLine * 16, drawWidth, drawHeight);
            }
        }
    }

    protected void drawTooltip(String tooltip) {
        this.func_74190_a(tooltip, this.mouseX, this.mouseY);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_74194_b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        Tab tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null && !tab.handleMouseClicked(this.mouseX, this.mouseY, mouseButton)) {
            if (tab.leftSide) {
                for (Tab other : this.tabListLeft) {
                    if (other == tab || !other.isOpen()) continue;
                    other.toggleOpen();
                }
            } else {
                for (Tab other : this.tabListRight) {
                    if (other == tab || !other.isOpen()) continue;
                    other.toggleOpen();
                }
            }
            tab.toggleOpen();
        }
    }

    public void func_73867_d() {
        int x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        int y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1;
        this.mouseX = x - (this.field_73880_f - this.field_74194_b) / 2;
        this.mouseY = y - (this.field_73881_g - this.field_74195_c) / 2;
        super.func_73867_d();
    }

    public void addTab(Tab tab) {
        if (tab.leftSide) {
            this.tabListLeft.add(tab);
            if (SessionVars.getOpenedLeftTab() != null && tab.getClass().equals(SessionVars.getOpenedLeftTab())) {
                tab.setFullyOpen();
            }
        } else {
            this.tabListRight.add(tab);
            if (SessionVars.getOpenedRightTab() != null && tab.getClass().equals(SessionVars.getOpenedRightTab())) {
                tab.setFullyOpen();
            }
        }
    }

    protected void drawTabs(int mX, int mY) {
        String tooltip;
        int yPosRight = 4;
        int yPosLeft = 4;
        for (Tab tab : this.tabListLeft) {
            tab.update();
            if (!tab.isVisible()) continue;
            tab.draw(0, yPosLeft);
            yPosLeft += tab.getHeight();
        }
        for (Tab tab : this.tabListRight) {
            tab.update();
            if (!tab.isVisible()) continue;
            tab.draw(this.field_74194_b, yPosRight);
            yPosRight += tab.getHeight();
        }
        Tab tab = this.getTabAtPosition(mX, mY);
        if (tab != null && (tooltip = tab.getTooltip()) != null) {
            this.drawTooltip(tooltip);
        }
    }

    protected Tab getTabAtPosition(int mX, int mY) {
        Tab tab;
        int i;
        int xShift = 0;
        int yShift = 4;
        for (i = 0; i < this.tabListLeft.size(); ++i) {
            tab = (Tab)this.tabListLeft.get(i);
            if (!tab.isVisible()) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.getHeight();
        }
        xShift = this.field_74194_b;
        yShift = 4;
        for (i = 0; i < this.tabListRight.size(); ++i) {
            tab = (Tab)this.tabListRight.get(i);
            if (!tab.isVisible()) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.getHeight();
        }
        return null;
    }

    protected static enum SlotRender {
        TOP,
        BOTTOM,
        FULL;

    }

    protected static enum SlotType {
        SINGLE,
        OUTPUT,
        DOUBLEOUTPUT;

    }

    protected static enum SlotColor {
        BLUE,
        RED,
        YELLOW,
        ORANGE,
        GREEN,
        PURPLE;

    }
}

