/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.research;

import java.util.HashMap;
import java.util.Map;
import thaumcraft.api.EnumTag;
import thaumcraft.api.research.ResearchItem;

public class ResearchList {
    public static int minDisplayColumn;
    public static int minDisplayRow;
    public static int maxDisplayColumn;
    public static int maxDisplayRow;
    public static Map research;
    public static Map craftingRecipesForResearch;

    public static ResearchItem getResearch(String key) {
        return (ResearchItem)research.get(key);
    }

    public static String getResearchName(String key) {
        ResearchItem rr = (ResearchItem)research.get(key);
        if (rr == null) {
            return "";
        }
        return rr.name;
    }

    public static byte[] getResearchTags(String key) {
        ResearchItem rr = (ResearchItem)research.get(key);
        if (rr == null) {
            return null;
        }
        byte[] output = new byte[rr.tags.size()];
        EnumTag[] et = rr.tags.getAspects();
        for (int a = 0; a < rr.tags.size(); ++a) {
            output[a] = (byte)et[a].id;
        }
        return output;
    }

    public static int getResearchPrimaryTag(String key) {
        int t = 0;
        int amt = 0;
        ResearchItem rr = (ResearchItem)research.get(key);
        if (rr == null) {
            return 0;
        }
        for (EnumTag tag : rr.tags.getAspects()) {
            if (rr.tags.getAmount(tag) <= amt) continue;
            t = tag.id;
            amt = rr.tags.getAmount(tag);
        }
        return t;
    }

    public static int getResearchAmount(String key, EnumTag tag) {
        ResearchItem rr = (ResearchItem)research.get(key);
        if (rr == null) {
            return 0;
        }
        return rr.tags.getAmount(tag);
    }

    static {
        research = new HashMap();
        craftingRecipesForResearch = new HashMap();
    }
}

