/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.crafting.IInfusionRecipe;

public class ShapedInfusionCraftingRecipes
implements IInfusionRecipe {
    public int recipeWidth;
    public int recipeHeight;
    public String key;
    public int cost;
    public ObjectTags tags;
    public ItemStack[] recipeItems;
    private ItemStack recipeOutput;
    public final int recipeOutputItemID;

    @Override
    public String getKey() {
        return this.key;
    }

    public ShapedInfusionCraftingRecipes(String key, int par1, int par2, ItemStack[] par3ArrayOfItemStack, ItemStack par4ItemStack, int cost, ObjectTags tags) {
        this.recipeOutputItemID = par4ItemStack.field_77993_c;
        this.recipeWidth = par1;
        this.recipeHeight = par2;
        this.recipeItems = par3ArrayOfItemStack;
        this.recipeOutput = par4ItemStack;
        this.key = key;
        this.cost = cost;
        this.tags = tags;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public boolean matches(IInventory par1InventoryCrafting, EntityPlayer player) {
        if (this.key.length() > 0 && !ThaumcraftApiHelper.isResearchComplete(player.field_71092_bJ, this.key)) {
            return false;
        }
        for (int var2 = 0; var2 <= 3 - this.recipeWidth; ++var2) {
            for (int var3 = 0; var3 <= 3 - this.recipeHeight; ++var3) {
                if (this.checkMatch(par1InventoryCrafting, var2, var3, true)) {
                    return true;
                }
                if (!this.checkMatch(par1InventoryCrafting, var2, var3, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(IInventory par1InventoryCrafting, int par2, int par3, boolean par4) {
        for (int var5 = 0; var5 < 3; ++var5) {
            for (int var6 = 0; var6 < 3; ++var6) {
                ItemStack var10;
                int var7 = var5 - par2;
                int var8 = var6 - par3;
                ItemStack var9 = null;
                if (var7 >= 0 && var8 >= 0 && var7 < this.recipeWidth && var8 < this.recipeHeight) {
                    var9 = par4 ? this.recipeItems[this.recipeWidth - var7 - 1 + var8 * this.recipeWidth] : this.recipeItems[var7 + var8 * this.recipeWidth];
                }
                if ((var10 = ThaumcraftApiHelper.getStackInRowAndColumn(par1InventoryCrafting, var5, var6)) == null && var9 == null) continue;
                if (var10 == null && var9 != null || var10 != null && var9 == null) {
                    return false;
                }
                if (var9.field_77993_c != var10.field_77993_c) {
                    return false;
                }
                if (var9.func_77960_j() != Short.MAX_VALUE && var9.func_77960_j() != var10.func_77960_j()) {
                    return false;
                }
                if (!var9.func_77942_o()) continue;
                NBTTagCompound tc = var9.func_77978_p();
                for (Object tag : tc.func_74758_c().toArray()) {
                    NBTBase base = (NBTBase)tag;
                    Class<?> nc = NBTBase.func_74733_a((byte)base.func_74732_a(), (String)base.func_74740_e()).getClass();
                    if (var10.func_77942_o() && nc.cast(var10.func_77978_p().func_74781_a(base.func_74740_e())).equals(nc.cast(base))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(IInventory par1InventoryCrafting) {
        return new ItemStack(this.recipeOutput.field_77993_c, this.recipeOutput.field_77994_a, this.recipeOutput.func_77960_j());
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public ObjectTags getTags() {
        return this.tags;
    }
}

