/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import cpw.mods.fml.common.FMLLog;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import org.w3c.dom.Document;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aura.AuraNode;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IInfusionRecipe;
import thaumcraft.api.crafting.RecipeCrucible;
import thaumcraft.api.crafting.ShapedArcaneCraftingRecipes;
import thaumcraft.api.crafting.ShapedInfusionCraftingRecipes;
import thaumcraft.api.crafting.ShapelessArcaneCraftingRecipes;
import thaumcraft.api.crafting.ShapelessInfusionCraftingRecipes;
import thaumcraft.api.research.IScanEventHandler;
import thaumcraft.api.research.ResearchList;

public class ThaumcraftApi {
    public static EnumToolMaterial toolMatThaumium = EnumHelper.addToolMaterial((String)"THAUMIUM", (int)3, (int)400, (float)7.0f, (int)2, (int)22);
    public static EnumToolMaterial toolMatElemental = EnumHelper.addToolMaterial((String)"THAUMIUM_ELEMENTAL", (int)3, (int)1500, (float)10.0f, (int)3, (int)18);
    public static EnumArmorMaterial armorMatThaumium = EnumHelper.addArmorMaterial((String)"THAUMIUM", (int)25, (int[])new int[]{2, 6, 5, 2}, (int)25);
    public static EnumArmorMaterial armorMatSpecial = EnumHelper.addArmorMaterial((String)"SPECIAL", (int)25, (int[])new int[]{1, 3, 2, 1}, (int)25);
    public static ArrayList portableHoleBlackList = new ArrayList();
    public static Document researchDoc = null;
    public static ArrayList apiResearchFiles = new ArrayList();
    public static ArrayList scanEventhandlers = new ArrayList();
    private static ArrayList crucibleRecipes = new ArrayList();
    private static List craftingRecipes = new ArrayList();
    private static HashMap smeltingBonus = new HashMap();
    private static ArrayList smeltingBonusExlusion = new ArrayList();
    public static Map objectTags = new HashMap();
    private static Method addFluxToClosest;
    private static Method decreaseClosestAura;
    private static Method increaseLowestAura;
    private static Method getClosestAuraWithinRange;
    private static Method getNodeCopy;
    private static Method queueNodeChanges;
    @Deprecated
    public static HashMap biomeInfo;
    @Deprecated
    public static HashMap crops;

    public static void registerResearchXML(String resourceLoc) {
        if (!apiResearchFiles.contains(resourceLoc)) {
            apiResearchFiles.add(resourceLoc);
        }
    }

    public static void registerScanEventhandler(IScanEventHandler scanEventHandler) {
        scanEventhandlers.add(scanEventHandler);
    }

    public static void addSmeltingBonus(ItemStack in, ItemStack out) {
        smeltingBonus.put(Arrays.asList(in.field_77993_c, in.func_77960_j()), new ItemStack(out.field_77993_c, 0, out.func_77960_j()));
    }

    public static ItemStack getSmeltingBonus(ItemStack in) {
        return (ItemStack)smeltingBonus.get(Arrays.asList(in.field_77993_c, in.func_77960_j()));
    }

    public static void addSmeltingBonusExclusion(ItemStack in) {
        smeltingBonusExlusion.add(Arrays.asList(in.field_77993_c, in.func_77960_j()));
    }

    public static boolean isSmeltingBonusExluded(ItemStack in) {
        return smeltingBonusExlusion.contains(Arrays.asList(in.field_77993_c, in.func_77960_j()));
    }

    public static List getCraftingRecipes() {
        return craftingRecipes;
    }

    public static void addArcaneCraftingRecipe(String key, int cost, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        int var9;
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (par2ArrayOfObj[var4] instanceof String[]) {
            String[] var7;
            String[] var8 = var7 = (String[])par2ArrayOfObj[var4++];
            var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String var11 = var8[var10];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        } else {
            while (par2ArrayOfObj[var4] instanceof String) {
                String var13 = (String)par2ArrayOfObj[var4++];
                ++var6;
                var5 = var13.length();
                var3 = var3 + var13;
            }
        }
        HashMap<Character, ItemStack> var14 = new HashMap<Character, ItemStack>();
        while (var4 < par2ArrayOfObj.length) {
            Character var16 = (Character)par2ArrayOfObj[var4];
            ItemStack var17 = null;
            if (par2ArrayOfObj[var4 + 1] instanceof Item) {
                var17 = new ItemStack((Item)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof Block) {
                var17 = new ItemStack((Block)par2ArrayOfObj[var4 + 1], 1, -1);
            } else if (par2ArrayOfObj[var4 + 1] instanceof ItemStack) {
                var17 = (ItemStack)par2ArrayOfObj[var4 + 1];
            }
            var14.put(var16, var17);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (var9 = 0; var9 < var5 * var6; ++var9) {
            char var18 = var3.charAt(var9);
            var15[var9] = var14.containsKey(Character.valueOf(var18)) ? ((ItemStack)var14.get(Character.valueOf(var18))).func_77946_l() : null;
        }
        craftingRecipes.add(new ShapedArcaneCraftingRecipes(key, var5, var6, var15, par1ItemStack, cost));
    }

    public static void addArcaneCraftingRecipe(String key, String recipeKey, int cost, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        ThaumcraftApi.addArcaneCraftingRecipe(key, cost, par1ItemStack, par2ArrayOfObj);
        ResearchList.craftingRecipesForResearch.put(recipeKey, Arrays.asList(ThaumcraftApi.getCraftingRecipes().size() - 1));
    }

    public static void addShapelessArcaneCraftingRecipe(String key, int cost, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        ArrayList<ItemStack> var3 = new ArrayList<ItemStack>();
        Object[] var4 = par2ArrayOfObj;
        int var5 = par2ArrayOfObj.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Object var7 = var4[var6];
            if (var7 instanceof ItemStack) {
                var3.add(((ItemStack)var7).func_77946_l());
                continue;
            }
            if (var7 instanceof Item) {
                var3.add(new ItemStack((Item)var7));
                continue;
            }
            if (!(var7 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipe!");
            }
            var3.add(new ItemStack((Block)var7));
        }
        craftingRecipes.add(new ShapelessArcaneCraftingRecipes(key, par1ItemStack, var3, cost));
    }

    public static void addShapelessArcaneCraftingRecipe(String key, String recipeKey, int cost, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        ThaumcraftApi.addShapelessArcaneCraftingRecipe(key, cost, par1ItemStack, par2ArrayOfObj);
        ResearchList.craftingRecipesForResearch.put(recipeKey, Arrays.asList(ThaumcraftApi.getCraftingRecipes().size() - 1));
    }

    public static void addInfusionCraftingRecipe(String key, int cost, ObjectTags tags, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        int var9;
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (par2ArrayOfObj[var4] instanceof String[]) {
            String[] var7;
            String[] var8 = var7 = (String[])par2ArrayOfObj[var4++];
            var9 = var7.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String var11 = var8[var10];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        } else {
            while (par2ArrayOfObj[var4] instanceof String) {
                String var13 = (String)par2ArrayOfObj[var4++];
                ++var6;
                var5 = var13.length();
                var3 = var3 + var13;
            }
        }
        HashMap<Character, ItemStack> var14 = new HashMap<Character, ItemStack>();
        while (var4 < par2ArrayOfObj.length) {
            Character var16 = (Character)par2ArrayOfObj[var4];
            ItemStack var17 = null;
            if (par2ArrayOfObj[var4 + 1] instanceof Item) {
                var17 = new ItemStack((Item)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof Block) {
                var17 = new ItemStack((Block)par2ArrayOfObj[var4 + 1], 1, -1);
            } else if (par2ArrayOfObj[var4 + 1] instanceof ItemStack) {
                var17 = (ItemStack)par2ArrayOfObj[var4 + 1];
            }
            var14.put(var16, var17);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (var9 = 0; var9 < var5 * var6; ++var9) {
            char var18 = var3.charAt(var9);
            var15[var9] = var14.containsKey(Character.valueOf(var18)) ? ((ItemStack)var14.get(Character.valueOf(var18))).func_77946_l() : null;
        }
        craftingRecipes.add(new ShapedInfusionCraftingRecipes(key, var5, var6, var15, par1ItemStack, cost, tags));
    }

    public static void addInfusionCraftingRecipe(String key, String recipeKey, int cost, ObjectTags tags, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        ThaumcraftApi.addInfusionCraftingRecipe(key, cost, tags, par1ItemStack, par2ArrayOfObj);
        ResearchList.craftingRecipesForResearch.put(recipeKey, Arrays.asList(ThaumcraftApi.getCraftingRecipes().size() - 1));
    }

    public static void addShapelessInfusionCraftingRecipe(String key, int cost, ObjectTags tags, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        ArrayList<ItemStack> var3 = new ArrayList<ItemStack>();
        Object[] var4 = par2ArrayOfObj;
        int var5 = par2ArrayOfObj.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Object var7 = var4[var6];
            if (var7 instanceof ItemStack) {
                var3.add(((ItemStack)var7).func_77946_l());
                continue;
            }
            if (var7 instanceof Item) {
                var3.add(new ItemStack((Item)var7));
                continue;
            }
            if (!(var7 instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipe!");
            }
            var3.add(new ItemStack((Block)var7));
        }
        craftingRecipes.add(new ShapelessInfusionCraftingRecipes(key, par1ItemStack, var3, cost, tags));
    }

    public static void addShapelessInfusionCraftingRecipe(String key, String recipeKey, int cost, ObjectTags tags, ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        ThaumcraftApi.addShapelessInfusionCraftingRecipe(key, cost, tags, par1ItemStack, par2ArrayOfObj);
        ResearchList.craftingRecipesForResearch.put(recipeKey, Arrays.asList(ThaumcraftApi.getCraftingRecipes().size() - 1));
    }

    public static void addCrucibleRecipe(String key, ItemStack result, int cost, ObjectTags tags) {
        ThaumcraftApi.getCrucibleRecipes().add(new RecipeCrucible(key, result, tags, cost));
    }

    public static void addCrucibleRecipe(String key, String recipeKey, ItemStack result, int cost, ObjectTags tags) {
        ThaumcraftApi.getCrucibleRecipes().add(new RecipeCrucible(key, recipeKey, result, tags, cost));
    }

    public static RecipeCrucible getCrucibleRecipe(String key) {
        for (Object r : ThaumcraftApi.getCrucibleRecipes()) {
            if (!(r instanceof RecipeCrucible) || !((RecipeCrucible)r).key.equals(key)) continue;
            return (RecipeCrucible)r;
        }
        return null;
    }

    public static RecipeCrucible getCrucibleRecipe(ItemStack stack) {
        for (Object r : ThaumcraftApi.getCrucibleRecipes()) {
            if (!(r instanceof RecipeCrucible) || !((RecipeCrucible)r).recipeOutput.func_77969_a(stack)) continue;
            return (RecipeCrucible)r;
        }
        return null;
    }

    public static String getCraftingRecipeKey(ItemStack stack) {
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            if (r instanceof IArcaneRecipe && ThaumcraftApiHelper.areItemsEqual(stack, ((IArcaneRecipe)r).getRecipeOutput())) {
                return ((IArcaneRecipe)r).getKey();
            }
            if (!(r instanceof IInfusionRecipe) || !ThaumcraftApiHelper.areItemsEqual(stack, ((IInfusionRecipe)r).getRecipeOutput())) continue;
            return ((IInfusionRecipe)r).getKey();
        }
        return "";
    }

    public static boolean exists(int id, int meta) {
        ObjectTags tmp = (ObjectTags)objectTags.get(Arrays.asList(id, meta));
        if (tmp == null) {
            tmp = (ObjectTags)objectTags.get(Arrays.asList(id, -1));
            if (meta == -1 && tmp == null) {
                int index = 0;
                do {
                    tmp = (ObjectTags)objectTags.get(Arrays.asList(id, index));
                } while (++index < 16 && tmp == null);
            }
            if (tmp == null) {
                return false;
            }
        }
        return true;
    }

    public static void registerObjectTag(int id, int meta, ObjectTags aspects) {
        aspects = ThaumcraftApiHelper.cullTags(aspects);
        objectTags.put(Arrays.asList(id, meta), aspects);
    }

    public static void registerComplexObjectTag(int id, int meta, ObjectTags aspects) {
        if (!ThaumcraftApi.exists(id, meta)) {
            ObjectTags tmp = ThaumcraftApiHelper.generateTags(id, meta);
            if (tmp != null && tmp.size() > 0) {
                for (EnumTag tag : tmp.getAspects()) {
                    aspects.add(tag, tmp.getAmount(tag));
                }
            }
            ThaumcraftApi.registerObjectTag(id, meta, aspects);
        } else {
            ObjectTags tmp = ThaumcraftApiHelper.getObjectTags(new ItemStack(id, 1, meta));
            for (EnumTag tag : aspects.getAspects()) {
                tmp.merge(tag, tmp.getAmount(tag));
            }
            ThaumcraftApi.registerObjectTag(id, meta, tmp);
        }
    }

    public static ArrayList getCrucibleRecipes() {
        return crucibleRecipes;
    }

    public static void addFluxToClosest(World world, float x, float y, float z, ObjectTags tags) {
        try {
            if (addFluxToClosest == null) {
                Class<?> fake = Class.forName("thaumcraft.common.aura.AuraManager");
                addFluxToClosest = fake.getMethod("addFluxToClosest", World.class, Float.TYPE, Float.TYPE, Float.TYPE, ObjectTags.class);
            }
            addFluxToClosest.invoke(null, world, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), tags);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.aura.AuraManager method addFluxToClosest", (Object[])new Object[0]);
        }
    }

    public static boolean decreaseClosestAura(World world, double x, double y, double z, int amount, boolean doit) {
        boolean ret = false;
        try {
            if (decreaseClosestAura == null) {
                Class<?> fake = Class.forName("thaumcraft.common.aura.AuraManager");
                decreaseClosestAura = fake.getMethod("decreaseClosestAura", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            ret = (Boolean)decreaseClosestAura.invoke(null, world, x, y, z, amount, doit);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.aura.AuraManager method decreaseClosestAura", (Object[])new Object[0]);
        }
        return ret;
    }

    public static boolean increaseLowestAura(World world, double x, double y, double z, int amount) {
        boolean ret = false;
        try {
            if (increaseLowestAura == null) {
                Class<?> fake = Class.forName("thaumcraft.common.aura.AuraManager");
                increaseLowestAura = fake.getMethod("increaseLowestAura", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE);
            }
            ret = (Boolean)increaseLowestAura.invoke(null, world, x, y, z, amount);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.aura.AuraManager method increaseLowestAura", (Object[])new Object[0]);
        }
        return ret;
    }

    public static int getClosestAuraWithinRange(World world, double x, double y, double z, double range) {
        int ret = -1;
        try {
            if (getClosestAuraWithinRange == null) {
                Class<?> fake = Class.forName("thaumcraft.common.aura.AuraManager");
                getClosestAuraWithinRange = fake.getMethod("getClosestAuraWithinRange", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            }
            ret = (Integer)getClosestAuraWithinRange.invoke(null, world, x, y, z, range);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.aura.AuraManager method getClosestAuraWithinRange", (Object[])new Object[0]);
        }
        return ret;
    }

    public static AuraNode getNodeCopy(int nodeId) {
        AuraNode node = null;
        try {
            if (getNodeCopy == null) {
                Class<?> fake = Class.forName("thaumcraft.common.aura.AuraManager");
                getNodeCopy = fake.getMethod("getNodeCopy", Integer.TYPE);
            }
            node = (AuraNode)getNodeCopy.invoke(null, nodeId);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.aura.AuraManager method getNodeCopy", (Object[])new Object[0]);
        }
        return node;
    }

    public static void queueNodeChanges(int nodeId, int levelMod, int baseMod, boolean toggleLock, ObjectTags flux, float x, float y, float z) {
        try {
            if (queueNodeChanges == null) {
                Class<?> fake = Class.forName("thaumcraft.common.aura.AuraManager");
                queueNodeChanges = fake.getMethod("queueNodeChanges", Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, ObjectTags.class, Float.TYPE, Float.TYPE, Float.TYPE);
            }
            queueNodeChanges.invoke(null, nodeId, levelMod, baseMod, toggleLock, flux, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.aura.AuraManager method queueNodeChanges", (Object[])new Object[0]);
        }
    }

    @Deprecated
    public static void registerBiomeInfo(int biomeID, int visLevel, EnumTag tag, boolean greatwood, boolean silverwood) {
        biomeInfo.put(biomeID, Arrays.asList(new Serializable[]{Integer.valueOf(visLevel), tag, Boolean.valueOf(greatwood), Boolean.valueOf(silverwood)}));
    }

    @Deprecated
    public static int getBiomeAura(int biomeId) {
        try {
            return (Integer)((List)biomeInfo.get(biomeId)).get(0);
        }
        catch (Exception exception) {
            return 200;
        }
    }

    @Deprecated
    public static EnumTag getBiomeTag(int biomeId) {
        try {
            return (EnumTag)((Object)((List)biomeInfo.get(biomeId)).get(1));
        }
        catch (Exception exception) {
            return EnumTag.UNKNOWN;
        }
    }

    @Deprecated
    public static boolean getBiomeSupportsGreatwood(int biomeId) {
        try {
            return (Boolean)((List)biomeInfo.get(biomeId)).get(2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    public static boolean getBiomeSupportsSilverwood(int biomeId) {
        try {
            return (Boolean)((List)biomeInfo.get(biomeId)).get(3);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Deprecated
    public static void addHarvestableCrop(int blockID, int grownMeta) {
        crops.put(blockID, grownMeta);
    }

    static {
        biomeInfo = new HashMap();
        crops = new HashMap();
    }
}

