/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.tracks;

import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackItemIconProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public final class TrackSpec {
    public static int blockID = 0;
    private final String tag;
    private final short trackId;
    private final ITrackItemIconProvider iconProvider;
    private final Class instanceClass;

    public TrackSpec(short trackId, String tag, ITrackItemIconProvider iconProvider, Class instanceClass) {
        this.trackId = trackId;
        this.tag = tag;
        this.iconProvider = iconProvider;
        this.instanceClass = instanceClass;
    }

    public String getTrackTag() {
        return this.tag;
    }

    public short getTrackId() {
        return this.trackId;
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        if (blockID <= 0) {
            return null;
        }
        return new ItemStack(blockID, qty, (int)this.getTrackId());
    }

    public ITrackInstance createInstanceFromSpec() {
        try {
            return (ITrackInstance)this.instanceClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Improper Track Instance Constructor");
        }
    }

    public Icon getIcon() {
        return this.iconProvider.getTrackItemIcon(this);
    }
}

