/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.core.CommonUtils;
import codechicken.core.featurehack.GameDataManipulator;
import codechicken.core.inventory.ItemKey;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEICompatibility;
import codechicken.nei.PopupInputHandler;
import codechicken.nei.api.API;
import codechicken.nei.api.IHighlightIdentifier;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import codechicken.nei.recipe.weakDependancy_Forge;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ItemInfo {
    public static final HashMap fallbackNames = new HashMap();
    public static final HashSet excludeIds = new HashSet();
    public static final HashSet nonUnlimitedIds = new HashSet();
    public static final HashMap damageVariants = new HashMap();
    public static final ArrayList defaultDamageRange = new ArrayList();
    public static final HashMap itemcompounds = new HashMap();
    public static final LinkedList infiniteHandlers = new LinkedList();
    public static final HashMap highlightIdentifiers = new HashMap();
    public static final HashSet fastTransferExemptions = new HashSet();

    public static boolean isHidden(int itemID) {
        return excludeIds.contains(itemID);
    }

    public static ArrayList getItemDamageVariants(int itemID) {
        ArrayList damages = (ArrayList)damageVariants.get(itemID);
        return damages == null ? defaultDamageRange : damages;
    }

    public static String getOverrideName(int itemID, int itemDamage) {
        ItemKey itemhash = new ItemKey(itemID, itemDamage);
        return (String)fallbackNames.get(itemhash);
    }

    public static boolean canItemBeUnlimited(int itemID) {
        return !nonUnlimitedIds.contains(itemID);
    }

    public static ArrayList getItemCompounds(int itemID) {
        return (ArrayList)itemcompounds.get(itemID);
    }

    public static void load(World world) {
        defaultDamageRange.add(new int[]{0, 15});
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.addModItemDropDowns();
        ItemInfo.addMobSpawnerItem(world);
        ItemInfo.addSpawnEggs();
        new BrewingRecipeHandler().searchPotions();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
    }

    private static void addModItemDropDowns() {
        NBTTagList itemDataList = new NBTTagList();
        GameData.writeItemData((NBTTagList)itemDataList);
        HashMap<String, MultiItemRange> modRangeMap = new HashMap<String, MultiItemRange>();
        for (int i = 0; i < itemDataList.func_74745_c(); ++i) {
            ItemData itemData = new ItemData((NBTTagCompound)itemDataList.func_74743_b(i));
            MultiItemRange itemRange = (MultiItemRange)modRangeMap.get(itemData.getModId());
            if (itemRange == null) {
                itemRange = new MultiItemRange();
                modRangeMap.put(itemData.getModId(), itemRange);
            }
            itemRange.add(itemData.getItemId());
        }
        for (Map.Entry entry : modRangeMap.entrySet()) {
            String modID = (String)entry.getKey();
            ModContainer mod = CommonUtils.findModContainer((String)modID);
            String modname = mod == null ? modID : mod.getName();
            API.addSetRange("Mod." + modname, (MultiItemRange)entry.getValue());
        }
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler((IContainerInputHandler)new PopupInputHandler());
    }

    private static void addMobSpawnerItem(final World world) {
        Item.field_77698_e[Block.field_72065_as.field_71990_ca] = null;
        GameDataManipulator.createHiddenItem((Runnable)new Runnable(){

            @Override
            public void run() {
                new ItemMobSpawner(world);
            }
        });
        if (NEICompatibility.hasForge) {
            weakDependancy_Forge.addMobSpawnerRenderer();
        }
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler((IInfiniteItemHandler)new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler((IInfiniteItemHandler)new InfiniteToolHandler());
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(Block.field_71942_A.field_71990_ca, 0, "Water Source");
        API.setMaxDamageException(Block.field_71942_A.field_71990_ca, 0);
        API.setOverrideName(Block.field_71943_B.field_71990_ca, 0, "Water Still");
        API.setMaxDamageException(Block.field_71943_B.field_71990_ca, 0);
        API.setOverrideName(Block.field_71944_C.field_71990_ca, 0, "Lava Source");
        API.setMaxDamageException(Block.field_71944_C.field_71990_ca, 0);
        API.setOverrideName(Block.field_71938_D.field_71990_ca, 0, "Lava Still");
        API.setMaxDamageException(Block.field_71938_D.field_71990_ca, 0);
        API.setOverrideName(Block.field_72006_bl.field_71990_ca, 0, "Silverfish Stone");
        API.setOverrideName(Block.field_72102_bH.field_71990_ca, 0, "End Portal");
        API.setOverrideName(Block.field_72104_bI.field_71990_ca, 0, "End Portal Frame");
        API.hideItem(Block.field_72099_aa.field_71990_ca);
        API.hideItem(Block.field_72095_ac.field_71990_ca);
        API.hideItem(Block.field_71999_bt.field_71990_ca);
        API.hideItem(Block.field_71996_bs.field_71990_ca);
        API.hideItem(Block.field_71959_S.field_71990_ca);
        API.hideItem(Block.field_72075_av.field_71990_ca);
        API.hideItem(Block.field_72058_az.field_71990_ca);
        API.hideItem(Block.field_72053_aD.field_71990_ca);
        API.hideItem(Block.field_72054_aE.field_71990_ca);
        API.hideItem(Block.field_72042_aI.field_71990_ca);
        API.hideItem(Block.field_72045_aL.field_71990_ca);
        API.hideItem(Block.field_72048_aO.field_71990_ca);
        API.hideItem(Block.field_72049_aP.field_71990_ca);
        API.hideItem(Block.field_72040_aX.field_71990_ca);
        API.hideItem(Block.field_72010_bh.field_71990_ca);
        API.hideItem(Block.field_72011_bi.field_71990_ca);
        API.hideItem(Block.field_72108_bG.field_71990_ca);
        API.hideItem(Block.field_72094_bD.field_71990_ca);
        API.hideItem(Block.field_72106_bF.field_71990_ca);
        API.hideItem(Block.field_72052_aC.field_71990_ca);
        API.hideItem(Block.field_72080_bM.field_71990_ca);
        API.hideItem(Block.field_82516_cf.field_71990_ca);
        API.hideItem(Block.field_82513_cg.field_71990_ca);
        API.hideItem(Block.field_82514_ch.field_71990_ca);
        API.hideItem(Block.field_82512_cj.field_71990_ca);
        API.hideItem(Block.field_72062_bU.field_71990_ca);
    }

    private static void addDefaultDropDowns() {
        API.addSetRange("Blocks", new MultiItemRange("[0-32000]"){

            public void addItemIfInRange(int item, int damage, NBTTagCompound compound) {
                if (item < Block.field_71973_m.length && Block.field_71973_m[item] != null && Block.field_71973_m[item].field_72018_cp != Material.field_76249_a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Items", new MultiItemRange("[0-32000]"){

            public void addItemIfInRange(int item, int damage, NBTTagCompound compound) {
                if (item >= Block.field_71973_m.length || Block.field_71973_m[item] == null || Block.field_71973_m[item].field_72018_cp == Material.field_76249_a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Blocks.MobSpawners", new MultiItemRange("[52]"));
    }

    private static void searchItems() {
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange picks = new MultiItemRange();
        MultiItemRange shovels = new MultiItemRange();
        MultiItemRange axes = new MultiItemRange();
        MultiItemRange hoes = new MultiItemRange();
        MultiItemRange swords = new MultiItemRange();
        MultiItemRange chest = new MultiItemRange();
        MultiItemRange helmets = new MultiItemRange();
        MultiItemRange legs = new MultiItemRange();
        MultiItemRange boots = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange ranged = new MultiItemRange();
        MultiItemRange food = new MultiItemRange();
        MultiItemRange potioningredients = new MultiItemRange();
        MultiItemRange[] creativeTabRanges = new MultiItemRange[CreativeTabs.field_78032_a.length];
        for (CreativeTabs creativeTabs : CreativeTabs.field_78032_a) {
            creativeTabRanges[creativeTabs.func_78021_a()] = new MultiItemRange();
        }
        for (CreativeTabs creativeTabs : Item.field_77698_e) {
            if (creativeTabs == null) continue;
            CreativeTabs itemTab = creativeTabs.func_77640_w();
            if (itemTab != null) {
                creativeTabRanges[itemTab.func_78021_a()].add((Item)creativeTabs);
            }
            if (creativeTabs.func_77645_m()) {
                tools.add((Item)creativeTabs);
                if (creativeTabs instanceof ItemPickaxe) {
                    picks.add((Item)creativeTabs);
                } else if (creativeTabs instanceof ItemSpade) {
                    shovels.add((Item)creativeTabs);
                } else if (creativeTabs instanceof ItemAxe) {
                    axes.add((Item)creativeTabs);
                } else if (creativeTabs instanceof ItemHoe) {
                    hoes.add((Item)creativeTabs);
                } else if (creativeTabs instanceof ItemSword) {
                    swords.add((Item)creativeTabs);
                } else if (creativeTabs instanceof ItemArmor) {
                    switch (((ItemArmor)creativeTabs).field_77881_a) {
                        case 0: {
                            helmets.add((Item)creativeTabs);
                            break;
                        }
                        case 1: {
                            chest.add((Item)creativeTabs);
                            break;
                        }
                        case 2: {
                            legs.add((Item)creativeTabs);
                            break;
                        }
                        case 3: {
                            boots.add((Item)creativeTabs);
                        }
                    }
                } else if (creativeTabs == Item.field_77704_l || creativeTabs == Item.field_77707_k) {
                    ranged.add((Item)creativeTabs);
                } else if (creativeTabs == Item.field_77749_aR || creativeTabs == Item.field_77709_i || creativeTabs == Item.field_77745_be) {
                    other.add((Item)creativeTabs);
                }
            }
            if (creativeTabs instanceof ItemFood) {
                food.add((Item)creativeTabs);
            }
            if (!creativeTabs.func_77632_u()) continue;
            BrewingRecipeHandler.ingredientIDs.add(creativeTabs.field_77779_bT);
            potioningredients.add((Item)creativeTabs);
        }
        API.addSetRange("Items.Tools.Pickaxes", picks);
        API.addSetRange("Items.Tools.Shovels", shovels);
        API.addSetRange("Items.Tools.Axes", axes);
        API.addSetRange("Items.Tools.Hoes", hoes);
        API.addSetRange("Items.Tools.Other", other);
        API.addSetRange("Items.Weapons.Swords", swords);
        API.addSetRange("Items.Weapons.Ranged", ranged);
        API.addSetRange("Items.Armor.ChestPlates", chest);
        API.addSetRange("Items.Armor.Leggings", legs);
        API.addSetRange("Items.Armor.Helmets", helmets);
        API.addSetRange("Items.Armor.Boots", boots);
        API.addSetRange("Items.Food", food);
        API.addSetRange("Items.Potions.Ingredients", potioningredients);
        for (CreativeTabs creativeTabs : CreativeTabs.field_78032_a) {
            if (creativeTabRanges[creativeTabs.func_78021_a()].ranges.size() <= 0) continue;
            API.addSetRange("CreativeTabs." + creativeTabs.func_78024_c(), creativeTabRanges[creativeTabs.func_78021_a()]);
        }
    }

    private static void addSpawnEggs() {
        ArrayList damages = new ArrayList();
        try {
            HashMap classToIDMapping = (HashMap)EntityList.field_75624_e;
            damages.add(classToIDMapping.get(EntityMooshroom.class));
            damages.add(classToIDMapping.get(EntitySkeleton.class));
            damages.add(classToIDMapping.get(EntityCreeper.class));
            damages.add(classToIDMapping.get(EntitySlime.class));
            damages.add(classToIDMapping.get(EntityZombie.class));
            damages.add(classToIDMapping.get(EntitySpider.class));
            damages.add(classToIDMapping.get(EntityChicken.class));
            damages.add(classToIDMapping.get(EntityCaveSpider.class));
            damages.add(classToIDMapping.get(EntityCow.class));
            damages.add(classToIDMapping.get(EntityEnderman.class));
            damages.add(classToIDMapping.get(EntityWolf.class));
            damages.add(classToIDMapping.get(EntityPigZombie.class));
            damages.add(classToIDMapping.get(EntitySquid.class));
            damages.add(classToIDMapping.get(EntityGhast.class));
            damages.add(classToIDMapping.get(EntityMagmaCube.class));
            damages.add(classToIDMapping.get(EntitySheep.class));
            damages.add(classToIDMapping.get(EntityBlaze.class));
            damages.add(classToIDMapping.get(EntityVillager.class));
            damages.add(classToIDMapping.get(EntitySilverfish.class));
            damages.add(classToIDMapping.get(EntityPig.class));
            damages.add(classToIDMapping.get(EntityOcelot.class));
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(EntitySnowman.class), 0xEEFFFF, 16753185);
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(EntityIronGolem.class), 12960449, 16769484);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        API.setItemDamageVariants(Item.field_77815_bC.field_77779_bT, damages);
    }

    private static void addEntityEgg(ArrayList damages, Integer ID, int i, int j) {
        damages.add(ID);
        EntityList.field_75627_a.put(ID, new EntityEggInfo(ID.intValue(), i, j));
    }

    public static ArrayList getIdentifierItems(World world, EntityPlayer player, MovingObjectPosition hit) {
        IShearable shearable;
        int x = hit.field_72311_b;
        int y = hit.field_72312_c;
        int z = hit.field_72309_d;
        Block mouseoverBlock = Block.field_71973_m[world.func_72798_a(x, y, z)];
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList handlers = new ArrayList();
        if (highlightIdentifiers.get(0) != null) {
            handlers.addAll((Collection)highlightIdentifiers.get(0));
        }
        if (highlightIdentifiers.get(mouseoverBlock.field_71990_ca) != null) {
            handlers.addAll((Collection)highlightIdentifiers.get(mouseoverBlock.field_71990_ca));
        }
        for (IHighlightIdentifier ident : handlers) {
            ItemStack item = ident.identifyHighlight(world, player, hit);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        ItemStack pick = mouseoverBlock.getPickBlock(hit, world, x, y, z);
        if (pick != null) {
            items.add(pick);
        }
        try {
            items.addAll(mouseoverBlock.getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ItemStack((Item)Item.field_77745_be), world, x, y, z)) {
            items.addAll(shearable.onSheared(new ItemStack((Item)Item.field_77745_be), world, x, y, z, 0));
        }
        if (items.size() == 0) {
            items.add(0, new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z)));
        }
        return items;
    }
}

