/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class UtilsBlock {
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final int[] SIDE_LEFT = new int[]{4, 5, 5, 4, 2, 3};
    public static final int[] SIDE_RIGHT = new int[]{5, 4, 4, 5, 3, 2};
    public static final int[] SIDE_OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};
    public static final int[] SIDE_UP = new int[]{2, 3, 1, 1, 1, 1};
    public static final int[] SIDE_DOWN = new int[]{3, 2, 0, 0, 0, 0};

    public static int getCurrentMousedOverSide(World world, EntityPlayer player) {
        double distance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        posVec.field_72448_b += (double)player.func_70047_e();
        lookVec = posVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        MovingObjectPosition mouseOver = player.field_70170_p.func_72933_a(posVec, lookVec);
        if (mouseOver != null) {
            return mouseOver.field_72310_e;
        }
        return 0;
    }

    public static int[] getAdjacentCoordinatesForSide(int x, int y, int z, int side) {
        return new int[]{x + SIDE_COORD_MOD[side][0], y + SIDE_COORD_MOD[side][1], z + SIDE_COORD_MOD[side][2]};
    }

    public static boolean fillTankWithContainer(ITankContainer theTile, EntityPlayer player) {
        ItemStack theContainer = player.func_71045_bC();
        LiquidStack theLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)theContainer);
        if (theLiquid != null && (theTile.fill(ForgeDirection.UNKNOWN, theLiquid, false) == theLiquid.amount || player.field_71075_bZ.field_75098_d)) {
            theTile.fill(ForgeDirection.UNKNOWN, theLiquid, true);
            ItemStack returnStack = UtilsBlock.consumeItem(theContainer);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
            }
            return true;
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack theStack) {
        if (theStack.field_77994_a == 1) {
            if (theStack.func_77973_b().func_77634_r()) {
                return theStack.func_77973_b().getContainerItemStack(theStack);
            }
            return null;
        }
        theStack.func_77979_a(1);
        return theStack;
    }
}

