/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import bluedart.item.tool.ItemForceSword;
import bluedart.item.tool.ItemPowerSaw;
import bluedart.utils.SocketHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class UpgradeHelper {
    public static NBTTagCompound getUpgradeCompound(ItemStack stack) {
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("upgrades")) {
            return new NBTTagCompound();
        }
        return stack.func_77978_p().func_74775_l("upgrades");
    }

    public static ItemStack setUpgradeData(ItemStack stack, String type, int level) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("upgrades")) {
            stack.func_77978_p().func_74766_a("upgrades", new NBTTagCompound());
        }
        NBTTagCompound upgrades = stack.func_77978_p().func_74775_l("upgrades");
        upgrades.func_74768_a(type, level);
        return stack;
    }

    public static NBTTagCompound getDartData(Entity entity) {
        NBTTagCompound comp = new NBTTagCompound();
        if (entity != null) {
            if (!entity.getEntityData().func_74764_b("DartCraft")) {
                entity.getEntityData().func_74766_a("DartCraft", new NBTTagCompound());
            }
            comp = entity.getEntityData().func_74775_l("DartCraft");
        }
        return comp;
    }

    public static NBTTagCompound getPlayerEquippedComp(EntityPlayer player) {
        if (player == null) {
            return new NBTTagCompound();
        }
        ItemStack stack = player.func_71045_bC();
        NBTTagCompound upgrades = new NBTTagCompound();
        boolean bane = SocketHelper.getUpgradeAmount(player, "Bane")[0] > 0;
        int bleed = SocketHelper.getUpgradeAmount(player, "Bleed")[0];
        if (stack != null) {
            if (stack.func_77973_b() instanceof ItemForceSword) {
                upgrades = (NBTTagCompound)UpgradeHelper.getUpgradeCompound(stack).func_74737_b();
            }
            if (stack.func_77973_b() instanceof ItemPowerSaw) {
                upgrades = (NBTTagCompound)SocketHelper.getSocketCompound(stack).func_74737_b();
            }
        }
        if (bane) {
            upgrades.func_74757_a("Bane", true);
        }
        if (bleed > 0) {
            upgrades.func_74768_a("Bleed", upgrades.func_74762_e("Bleed") + bleed);
        }
        return upgrades;
    }
}

