/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import bluedart.api.DartAPI;
import bluedart.api.IForceUpgrade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TomeUtils {
    public static final int TIER_TWO = 96;
    public static final int TIER_THREE = 270;
    public static final int TIER_FOUR = 600;
    public static final int TIER_FIVE = 1020;
    public static final int TIER_SIX = 1440;
    public static final int TIER_SEVEN = 2400;
    public static final int TYPE_UPGRADE = 0;
    public static final int TYPE_CRAFT = 1;
    public static final int TYPE_EXP = 2;

    public static int getPoints(ItemStack stack) {
        int points = 0;
        if (stack.func_77942_o()) {
            NBTTagCompound comp = stack.func_77978_p();
            for (IForceUpgrade upgrade : DartAPI.fum.upgrades) {
                if (!comp.func_74764_b(upgrade.getName())) continue;
                points += TomeUtils.pointsFromTier(upgrade.getTier()) * comp.func_74762_e(upgrade.getName());
                if (comp.func_74762_e(upgrade.getName()) <= 0) continue;
                points += 25;
            }
            points += comp.func_74762_e("bonus");
        }
        return points;
    }

    private static int pointsFromTier(int tier) {
        switch (tier) {
            case 0: {
                return 1;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 15;
            }
            case 3: 
            case 4: {
                return 25;
            }
            case 5: 
            case 6: {
                return 50;
            }
        }
        return 0;
    }

    public static int getTier(int points) {
        if (points < 96) {
            return 1;
        }
        if (points < 270) {
            return 2;
        }
        if (points < 600) {
            return 3;
        }
        if (points < 1020) {
            return 4;
        }
        if (points < 1440) {
            return 5;
        }
        if (points < 2400) {
            return 6;
        }
        return 7;
    }

    public static int getPointsToNext(int points) {
        if (points < 96) {
            return 96 - points;
        }
        if (points < 270) {
            return 270 - points;
        }
        if (points < 600) {
            return 600 - points;
        }
        if (points < 1020) {
            return 1020 - points;
        }
        if (points < 1440) {
            return 1440 - points;
        }
        if (points < 2400) {
            return 2400 - points;
        }
        return 0;
    }

    public static NBTTagCompound initUpgradeComp(boolean debug) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("type", 0);
        for (IForceUpgrade upgrade : DartAPI.fum.upgrades) {
            data.func_74768_a(upgrade.getName(), 0);
        }
        if (debug) {
            data.func_74768_a("bonus", 2400);
        } else {
            data.func_74768_a("bonus", 0);
        }
        return data;
    }

    public static NBTTagCompound initExpComp() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("type", 2);
        data.func_74768_a("stored", 0);
        return data;
    }
}

