/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import bluedart.api.DartAPI;
import bluedart.api.IForceUpgrade;
import bluedart.core.Config;
import bluedart.item.ItemForceArmor;
import bluedart.item.tool.ItemForceSword;
import bluedart.item.tool.ItemPowerSaw;
import bluedart.utils.ItemInventory;
import bluedart.utils.UpgradeHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SocketHelper {
    public static NBTTagCompound getSocketCompound(ItemStack stack) {
        ItemForceArmor inst;
        NBTTagCompound checkComp;
        NBTTagCompound upgrades = new NBTTagCompound();
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("contents")) {
            return upgrades;
        }
        if (stack.func_77973_b() instanceof ItemForceArmor && ((checkComp = UpgradeHelper.getUpgradeCompound(stack)).func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) && !(inst = (ItemForceArmor)stack.func_77973_b()).canUse(stack, 100)) {
            return upgrades;
        }
        ItemInventory inv = new ItemInventory(stack.func_77978_p().func_74762_e("size"), stack);
        if (inv.func_70302_i_() > 0) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack tempStack = inv.func_70301_a(i);
                if (tempStack == null) continue;
                NBTTagCompound tempComp = UpgradeHelper.getUpgradeCompound(tempStack);
                for (IForceUpgrade upgrade : DartAPI.fum.upgrades) {
                    if (!tempComp.func_74764_b(upgrade.getName()) || upgrades.func_74762_e(upgrade.getName()) >= tempComp.func_74762_e(upgrade.getName())) continue;
                    upgrades.func_74768_a(upgrade.getName(), tempComp.func_74762_e(upgrade.getName()));
                }
            }
        }
        return upgrades;
    }

    public static NBTTagCompound getArmorCompound(EntityPlayer player) {
        NBTTagCompound upgrades = new NBTTagCompound();
        for (ItemStack armor : player.field_71071_by.field_70460_b) {
            NBTTagCompound comp = UpgradeHelper.getUpgradeCompound(armor);
            for (IForceUpgrade upgrade : DartAPI.fum.upgrades) {
                if (!comp.func_74764_b(upgrade.getName())) continue;
                upgrades.func_74768_a(upgrade.getName(), upgrades.func_74762_e(upgrade.getName()) + comp.func_74762_e(upgrade.getName()));
            }
        }
        return upgrades;
    }

    public static int getSocketDamage(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("damage")) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("damage");
    }

    public static int getMaxFlight(EntityPlayer player) {
        if (player == null) {
            return 0;
        }
        int[] values = SocketHelper.getUpgradeAmount(player, "Wing");
        int flight = values[0] * Config.maxFlight + Config.maxFlight;
        return flight;
    }

    public static boolean canPlayerFly(EntityPlayer player) {
        NBTTagCompound upgrades;
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemForceSword && stack.func_77942_o() ? (upgrades = UpgradeHelper.getUpgradeCompound(stack)).func_74764_b("Wing") : stack != null && stack.func_77973_b() instanceof ItemPowerSaw && (upgrades = SocketHelper.getSocketCompound(stack)).func_74764_b("Wing")) {
            return true;
        }
        for (ItemStack armor : player.field_71071_by.field_70460_b) {
            NBTTagCompound comp;
            if (armor == null || !(armor.func_77973_b() instanceof ItemForceArmor) || !armor.func_77942_o() || !(comp = UpgradeHelper.getUpgradeCompound(armor)).func_74764_b("Wing")) continue;
            return true;
        }
        return false;
    }

    public static int[] getUpgradeAmount(EntityPlayer player, String check) {
        int[] ret = new int[]{0, 0, 0};
        for (ItemStack armor : player.field_71071_by.field_70460_b) {
            ItemForceArmor arm;
            NBTTagCompound upgrades;
            if (armor == null || !(armor.func_77973_b() instanceof ItemForceArmor) || ((upgrades = UpgradeHelper.getUpgradeCompound(armor)).func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) && !(arm = (ItemForceArmor)armor.func_77973_b()).canUse(armor, 100)) continue;
            ret[2] = ret[2] + 1;
            if (!armor.func_77942_o() || !upgrades.func_74764_b(check)) continue;
            ret[0] = ret[0] + 1;
            ret[1] = ret[1] + upgrades.func_74762_e(check);
        }
        return ret;
    }
}

