/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import bluedart.utils.INBTTagable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemInventory
implements IInventory,
INBTTagable {
    public boolean isItemInventory = false;
    public ItemStack parent;
    protected ItemStack[] contents;
    private Container eventHandler;

    public ItemInventory(int size) {
        this.contents = new ItemStack[size];
    }

    public ItemInventory(int size, ItemStack stack) {
        this(size);
        this.parent = stack;
        this.isItemInventory = true;
        this.contents = new ItemStack[size];
        this.readFromNBT(stack.func_77978_p());
    }

    public void onGuiSaved(EntityPlayer player) {
        this.parent = this.findParent(player);
        if (this.parent != null) {
            this.save();
        }
    }

    public ItemStack findParent(EntityPlayer player) {
        NBTTagCompound playerComp;
        if (this.parent == null) {
            return null;
        }
        NBTTagCompound comp = this.parent.func_77978_p();
        if (comp == null) {
            return null;
        }
        int id = comp.func_74762_e("ID");
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            NBTTagCompound playerComp2;
            if (player.field_71071_by.func_70301_a(i) == null || (playerComp2 = player.field_71071_by.func_70301_a(i).func_77978_p()) == null || id != playerComp2.func_74762_e("ID")) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        if (player.field_71071_by.func_70445_o() != null && (playerComp = player.field_71071_by.func_70445_o().func_77978_p()) != null && id == playerComp.func_74762_e("ID")) {
            return player.field_71071_by.func_70445_o();
        }
        return null;
    }

    public boolean matchesID(int secondID) {
        if (this.parent == null) {
            return false;
        }
        NBTTagCompound comp = this.parent.func_77978_p();
        if (comp == null) {
            return false;
        }
        int id = comp.func_74762_e("ID");
        return id == secondID;
    }

    public void save() {
        NBTTagCompound comp = this.parent.func_77978_p();
        if (comp == null) {
            comp = new NBTTagCompound();
        }
        this.writeToNBT(comp);
        this.parent.func_77982_d(comp);
    }

    @Override
    public void readFromNBT(NBTTagCompound comp) {
        if (comp == null) {
            return;
        }
        if (comp.func_74764_b("contents")) {
            NBTTagList contentList = comp.func_74761_m("contents");
            this.contents = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < contentList.func_74745_c(); ++i) {
                NBTTagCompound tempComp = (NBTTagCompound)contentList.func_74743_b(i);
                byte slotByte = tempComp.func_74771_c("Slot");
                if (slotByte < 0 || slotByte >= this.contents.length) continue;
                this.contents[slotByte] = ItemStack.func_77949_a((NBTTagCompound)tempComp);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound comp) {
        NBTTagList contentList = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] != null) {
                NBTTagCompound tempComp = new NBTTagCompound();
                tempComp.func_74774_a("Slot", (byte)i);
                this.contents[i].func_77955_b(tempComp);
                contentList.func_74742_a((NBTBase)tempComp);
            }
            comp.func_74782_a("contents", (NBTBase)contentList);
        }
    }

    public void setCraftingListener(Container container) {
        this.eventHandler = container;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.contents[i] == null) {
            return null;
        }
        if (this.contents[i].field_77994_a <= j) {
            ItemStack product = this.contents[i];
            this.contents[i] = null;
            this.func_70296_d();
            return product;
        }
        ItemStack product = this.contents[i].func_77979_a(j);
        if (this.contents[i].field_77994_a == 0) {
            this.contents[i] = null;
        }
        this.func_70296_d();
        return product;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.contents[slot] == null) {
            return null;
        }
        ItemStack returnVal = this.contents[slot];
        this.contents[slot] = null;
        this.func_70296_d();
        return returnVal;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.contents[index] = stack;
        this.func_70296_d();
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int getFreeSlots() {
        int free = 0;
        if (this.contents != null && this.contents.length > 0) {
            for (ItemStack checkStack : this.contents) {
                if (checkStack != null) continue;
                ++free;
            }
        }
        return free;
    }

    private int storePartialItemStack(ItemStack stack) {
        int i = stack.field_77993_c;
        int j = stack.field_77994_a;
        if (stack.func_77976_d() == 1) {
            int k = this.getFirstEmptyStack();
            if (k < 0) {
                return j;
            }
            if (this.contents[k] == null) {
                this.contents[k] = ItemStack.func_77944_b((ItemStack)stack);
            }
            return 0;
        }
        int k = this.storeItemStack(stack);
        if (k < 0) {
            k = this.getFirstEmptyStack();
        }
        if (k < 0) {
            return j;
        }
        if (this.contents[k] == null) {
            this.contents[k] = new ItemStack(i, 0, stack.func_77960_j());
            if (stack.func_77942_o()) {
                this.contents[k].func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
        }
        int l = j;
        if (j > this.contents[k].func_77976_d() - this.contents[k].field_77994_a) {
            l = this.contents[k].func_77976_d() - this.contents[k].field_77994_a;
        }
        if (l > this.func_70297_j_() - this.contents[k].field_77994_a) {
            l = this.func_70297_j_() - this.contents[k].field_77994_a;
        }
        if (l == 0) {
            return j;
        }
        this.contents[k].field_77994_a += l;
        this.contents[k].field_77992_b = 5;
        return j -= l;
    }

    public int storeItemStack(ItemStack stack) {
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null || this.contents[i].field_77993_c != stack.field_77993_c || !this.contents[i].func_77985_e() || this.contents[i].field_77994_a >= this.contents[i].func_77976_d() || this.contents[i].field_77994_a >= this.func_70297_j_() || this.contents[i].func_77981_g() && this.contents[i].func_77960_j() != stack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)this.contents[i], (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public boolean addItemToInventory(ItemStack stack) {
        int i;
        if (stack == null) {
            return false;
        }
        if (stack.func_77951_h()) {
            int i2 = this.getFirstEmptyStack();
            if (i2 >= 0) {
                this.contents[i2] = ItemStack.func_77944_b((ItemStack)stack);
                this.contents[i2].field_77992_b = 5;
                stack.field_77994_a = 0;
                this.func_70296_d();
                return true;
            }
            return false;
        }
        do {
            i = stack.field_77994_a;
            stack.field_77994_a = this.storePartialItemStack(stack);
        } while (stack.field_77994_a > 0 && stack.field_77994_a < i);
        return stack.field_77994_a < i;
    }

    public ItemStack func_70301_a(int index) {
        return this.contents[index];
    }

    public int func_70302_i_() {
        return this.contents.length;
    }

    public String func_70303_b() {
        return "inventory.simulated";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        if (this.eventHandler != null) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

