/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemCraftingInventory
extends InventoryCrafting
implements IInventory {
    public boolean isItemInventory = false;
    public ItemStack parent;
    protected ItemStack[] contents;
    private Container eventHandler;

    public ItemCraftingInventory(int size) {
        super(null, 3, 3);
        this.contents = new ItemStack[size];
    }

    public ItemCraftingInventory(int size, ItemStack stack) {
        this(size);
        this.parent = stack;
        this.isItemInventory = true;
        if (stack != null && stack.func_77942_o()) {
            this.readFromNBT(stack.func_77978_p());
        }
    }

    public void onGuiSaved(EntityPlayer player) {
        this.parent = this.findParent(player);
        if (this.parent != null) {
            this.save();
        }
    }

    public ItemStack findParent(EntityPlayer player) {
        NBTTagCompound playerComp;
        if (this.parent == null) {
            return null;
        }
        NBTTagCompound comp = this.parent.func_77978_p();
        if (comp == null) {
            return null;
        }
        int id = comp.func_74762_e("ID");
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            NBTTagCompound playerComp2;
            if (player.field_71071_by.func_70301_a(i) == null || (playerComp2 = player.field_71071_by.func_70301_a(i).func_77978_p()) == null || id != playerComp2.func_74762_e("ID")) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        if (player.field_71071_by.func_70445_o() != null && (playerComp = player.field_71071_by.func_70445_o().func_77978_p()) != null && id == playerComp.func_74762_e("ID")) {
            return player.field_71071_by.func_70445_o();
        }
        return null;
    }

    public boolean matchesID(int secondID) {
        if (this.parent == null) {
            return false;
        }
        NBTTagCompound comp = this.parent.func_77978_p();
        if (comp == null) {
            return false;
        }
        int id = comp.func_74762_e("ID");
        return id == secondID;
    }

    public void save() {
        NBTTagCompound comp = this.parent.func_77978_p();
        if (comp == null) {
            comp = new NBTTagCompound();
        }
        this.writeToNBT(comp);
        this.parent.func_77982_d(comp);
    }

    public void readFromNBT(NBTTagCompound comp) {
        if (comp == null) {
            return;
        }
        if (comp.func_74764_b("contents")) {
            NBTTagList contentList = comp.func_74761_m("contents");
            this.contents = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < contentList.func_74745_c(); ++i) {
                NBTTagCompound tempComp = (NBTTagCompound)contentList.func_74743_b(i);
                byte slotByte = tempComp.func_74771_c("Slot");
                if (slotByte < 0 || slotByte >= this.contents.length) continue;
                this.contents[slotByte] = ItemStack.func_77949_a((NBTTagCompound)tempComp);
            }
        }
    }

    public void writeToNBT(NBTTagCompound comp) {
        NBTTagList contentList = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] != null) {
                NBTTagCompound tempComp = new NBTTagCompound();
                tempComp.func_74774_a("Slot", (byte)i);
                this.contents[i].func_77955_b(tempComp);
                contentList.func_74742_a((NBTBase)tempComp);
            }
            comp.func_74782_a("contents", (NBTBase)contentList);
        }
    }

    public void setCraftingListener(Container container) {
        this.eventHandler = container;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.contents == null || this.contents.length <= i || i < 0 || this.contents[i] == null) {
            return null;
        }
        if (this.contents[i].field_77994_a <= j) {
            ItemStack product = this.contents[i];
            this.contents[i] = null;
            this.func_70296_d();
            return product;
        }
        ItemStack product = this.contents[i].func_77979_a(j);
        if (this.contents[i].field_77994_a == 0) {
            this.contents[i] = null;
        }
        this.func_70296_d();
        return product;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.contents == null || this.contents.length <= slot || slot < 0 || this.contents[slot] == null) {
            return null;
        }
        ItemStack returnVal = this.contents[slot];
        this.contents[slot] = null;
        this.func_70296_d();
        return returnVal;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.contents == null || this.contents.length <= index || index < 0) {
            return;
        }
        this.contents[index] = stack;
        this.func_70296_d();
    }

    public ItemStack func_70301_a(int index) {
        if (this.contents != null && this.contents.length > index) {
            return this.contents[index];
        }
        return null;
    }

    public int func_70302_i_() {
        return this.contents != null ? this.contents.length : 0;
    }

    public String func_70303_b() {
        return "inventory.simulated";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        if (this.eventHandler != null) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }
}

