/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import bluedart.item.DartItem;
import bluedart.utils.ItemInventory;
import bluedart.utils.UpgradeHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtils {
    public static ItemStack[] readItemsFromNBT(NBTTagCompound comp) {
        int i;
        if (comp == null) {
            return null;
        }
        ItemStack[] returnVal = null;
        ArrayList<ItemStack> buffer = new ArrayList<ItemStack>();
        NBTTagList contentList = comp.func_74761_m("contents");
        for (i = 0; i < contentList.func_74745_c(); ++i) {
            ItemStack tempStack = null;
            if (contentList.func_74743_b(i) != null && contentList.func_74743_b(i) instanceof NBTTagCompound) {
                tempStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)contentList.func_74743_b(i)));
            }
            buffer.add(tempStack);
        }
        if (buffer.size() > 0) {
            returnVal = new ItemStack[buffer.size()];
            for (i = 0; i < buffer.size(); ++i) {
                returnVal[i] = buffer.get(i) != null ? ((ItemStack)buffer.get(i)).func_77946_l() : null;
            }
        }
        return returnVal;
    }

    public static NBTTagCompound saveItemsToNBT(ItemStack[] items) {
        NBTTagCompound comp = new NBTTagCompound();
        if (items == null || items.length < 1) {
            return comp;
        }
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            NBTTagCompound tempComp = new NBTTagCompound();
            if (items[i] != null) {
                items[i].func_77955_b(tempComp);
            }
            contents.func_74742_a((NBTBase)tempComp);
        }
        comp.func_74782_a("contents", (NBTBase)contents);
        return comp;
    }

    public static boolean isForgeItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        int id = OreDictionary.getOreID((ItemStack)stack);
        if (id >= 0) {
            ArrayList ores = OreDictionary.getOres((Integer)id);
            return ores != null && ores.size() > 1;
        }
        return false;
    }

    public static boolean isItemEquivalent(ItemStack first, ItemStack second) {
        ArrayList firstOres;
        if (OreDictionary.itemMatches((ItemStack)first, (ItemStack)second, (boolean)false)) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        int firstID = OreDictionary.getOreID((ItemStack)first);
        if (firstID > 0 && (firstOres = OreDictionary.getOres((Integer)firstID)) != null && firstOres.size() > 0) {
            for (ItemStack tempStack : firstOres) {
                if (!OreDictionary.itemMatches((ItemStack)tempStack, (ItemStack)second, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getDartPack(ArrayList items, String name, int color) {
        int size;
        int n = size = items != null ? items.size() : 0;
        if (size % 8 != 0) {
            size = size - size % 8 + 8;
        }
        if (size < 8) {
            size = 8;
        }
        if (size > 40) {
            size = 40;
        }
        ItemStack packStack = new ItemStack((Item)DartItem.forcePack, 1, color);
        InventoryUtils.initializeInv(packStack, 40, size);
        if (name != null && !name.equals("")) {
            packStack.func_77978_p().func_74778_a("name", name);
        }
        if (items == null || size < items.size()) {
            return packStack;
        }
        ItemInventory inv = new ItemInventory(size, packStack);
        if (items != null && items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                inv.func_70299_a(i, (ItemStack)items.get(i));
            }
        }
        inv.save();
        packStack.func_77978_p().func_82580_o("ID");
        return packStack;
    }

    public static void initializeInv(ItemStack pack, int maxSize, int size) {
        if (!pack.func_77942_o()) {
            NBTTagCompound comp = new NBTTagCompound();
            if (maxSize > 0) {
                comp.func_74768_a("size", size);
            }
            NBTTagList contents = new NBTTagList();
            for (int i = 0; i < maxSize; ++i) {
                NBTTagCompound itemComp = new NBTTagCompound();
                itemComp.func_74774_a("Slot", (byte)i);
                contents.func_74742_a((NBTBase)itemComp);
            }
            comp.func_74782_a("contents", (NBTBase)contents);
            pack.func_77982_d(comp);
        }
    }

    public static ItemStack getBoxedChest(ArrayList items) {
        TileEntityChest chest;
        ItemStack chestStack = new ItemStack((Item)DartItem.tileBox);
        chestStack.func_77982_d(new NBTTagCompound());
        TileEntityChest inv = chest = new TileEntityChest();
        if (items != null && items.size() > 0) {
            for (int i = 0; i < (items.size() < 28 ? items.size() : 27); ++i) {
                inv.func_70299_a(i, (ItemStack)items.get(i));
            }
        }
        NBTTagCompound chestComp = new NBTTagCompound();
        chest.func_70310_b(chestComp);
        chestStack.func_77978_p().func_74766_a("tile", chestComp);
        ItemStack blockStack = new ItemStack((Block)Block.field_72077_au);
        chestStack.func_77978_p().func_74766_a("block", blockStack.func_77955_b(new NBTTagCompound()));
        return chestStack;
    }

    public static ItemStack getCore(String type, int level, int num) {
        if (num > DartItem.upgradeCore.func_77639_j()) {
            num = DartItem.upgradeCore.func_77639_j();
        }
        ItemStack coreStack = new ItemStack(DartItem.upgradeCore, num);
        coreStack.func_77982_d(new NBTTagCompound());
        coreStack.func_77978_p().func_74766_a("upgrades", new NBTTagCompound());
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(coreStack);
        upgrades.func_74768_a(type, level);
        return coreStack;
    }

    public static ItemStack getRod(String type, int level) {
        ItemStack rodStack = new ItemStack((Item)DartItem.forceRod);
        rodStack.func_77982_d(new NBTTagCompound());
        rodStack.func_77978_p().func_74766_a("upgrades", new NBTTagCompound());
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(rodStack);
        upgrades.func_74768_a(type, level);
        return rodStack;
    }

    public static ItemStack getClipboard(ItemStack[] items) {
        ItemStack clipboard = new ItemStack((Item)DartItem.clipboard);
        ItemInventory inv = new ItemInventory(9, clipboard);
        if (items != null && items.length > 0) {
            for (int i = 0; i < (items.length < 9 ? items.length : 9); ++i) {
                inv.func_70299_a(i, items[i]);
            }
        }
        inv.save();
        clipboard.func_77978_p().func_82580_o("ID");
        return clipboard;
    }

    public static ItemStack getCard(ItemStack[] items) {
        ItemStack cardStack = new ItemStack((Item)DartItem.memberCard);
        InventoryUtils.initializeInv(cardStack, 0, 16);
        ItemInventory inv = new ItemInventory(16, cardStack);
        if (items != null && items.length > 0) {
            for (int i = 0; i < items.length; ++i) {
                inv.func_70299_a(i, items[i]);
                if (i > 15) break;
            }
        }
        inv.save();
        cardStack.func_77978_p().func_82580_o("ID");
        return cardStack;
    }

    public static ItemStack setCardData(ItemStack stack, int num) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("mode", (byte)num);
        return stack;
    }

    public static boolean forgify(EntityPlayer player, ItemInventory packInv, ItemInventory cardInv) {
        if (packInv == null || player == null || cardInv == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < cardInv.func_70302_i_(); ++i) {
            ArrayList ores;
            int id;
            ItemStack cardStack = cardInv.func_70301_a(i);
            if (cardStack == null || (id = OreDictionary.getOreID((ItemStack)cardStack)) < 0 || (ores = OreDictionary.getOres((Integer)id)) == null || ores.size() < 2) continue;
            block1: for (int j = 0; j < packInv.func_70302_i_(); ++j) {
                ItemStack invStack = packInv.func_70301_a(j);
                if (invStack == null || OreDictionary.itemMatches((ItemStack)cardStack, (ItemStack)invStack, (boolean)false)) continue;
                for (ItemStack oreCheck : ores) {
                    if (!OreDictionary.itemMatches((ItemStack)oreCheck, (ItemStack)invStack, (boolean)false)) continue;
                    ItemStack bufferStack = invStack.func_77946_l();
                    packInv.func_70299_a(j, new ItemStack(cardStack.field_77993_c, invStack.field_77994_a, cardStack.func_77960_j()));
                    if (bufferStack.func_77942_o()) {
                        packInv.func_70301_a(j).func_77982_d((NBTTagCompound)bufferStack.func_77978_p().func_74737_b());
                    }
                    changed = true;
                    continue block1;
                }
            }
        }
        if (changed) {
            packInv.save();
        }
        return changed;
    }
}

